/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Privacy evaluation scores that measure the privacy characteristics of the generated synthetic data, including
 * assessments of potential privacy risks such as membership inference attacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrivacyScores implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPrivacyScores.Builder, DataPrivacyScores> {
    private static final SdkField<List<MembershipInferenceAttackScore>> MEMBERSHIP_INFERENCE_ATTACK_SCORES_FIELD = SdkField
            .<List<MembershipInferenceAttackScore>> builder(MarshallingType.LIST)
            .memberName("membershipInferenceAttackScores")
            .getter(getter(DataPrivacyScores::membershipInferenceAttackScores))
            .setter(setter(Builder::membershipInferenceAttackScores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipInferenceAttackScores")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MembershipInferenceAttackScore> builder(MarshallingType.SDK_POJO)
                                            .constructor(MembershipInferenceAttackScore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEMBERSHIP_INFERENCE_ATTACK_SCORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MembershipInferenceAttackScore> membershipInferenceAttackScores;

    private DataPrivacyScores(BuilderImpl builder) {
        this.membershipInferenceAttackScores = builder.membershipInferenceAttackScores;
    }

    /**
     * For responses, this returns true if the service returned a value for the MembershipInferenceAttackScores
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMembershipInferenceAttackScores() {
        return membershipInferenceAttackScores != null && !(membershipInferenceAttackScores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which attempt to
     * determine whether a specific individual was a member of the original dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembershipInferenceAttackScores}
     * method.
     * </p>
     * 
     * @return Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which
     *         attempt to determine whether a specific individual was a member of the original dataset.
     */
    public final List<MembershipInferenceAttackScore> membershipInferenceAttackScores() {
        return membershipInferenceAttackScores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMembershipInferenceAttackScores() ? membershipInferenceAttackScores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrivacyScores)) {
            return false;
        }
        DataPrivacyScores other = (DataPrivacyScores) obj;
        return hasMembershipInferenceAttackScores() == other.hasMembershipInferenceAttackScores()
                && Objects.equals(membershipInferenceAttackScores(), other.membershipInferenceAttackScores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DataPrivacyScores")
                .add("MembershipInferenceAttackScores",
                        hasMembershipInferenceAttackScores() ? membershipInferenceAttackScores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipInferenceAttackScores":
            return Optional.ofNullable(clazz.cast(membershipInferenceAttackScores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipInferenceAttackScores", MEMBERSHIP_INFERENCE_ATTACK_SCORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrivacyScores, T> g) {
        return obj -> g.apply((DataPrivacyScores) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrivacyScores> {
        /**
         * <p>
         * Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which attempt
         * to determine whether a specific individual was a member of the original dataset.
         * </p>
         * 
         * @param membershipInferenceAttackScores
         *        Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which
         *        attempt to determine whether a specific individual was a member of the original dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipInferenceAttackScores(Collection<MembershipInferenceAttackScore> membershipInferenceAttackScores);

        /**
         * <p>
         * Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which attempt
         * to determine whether a specific individual was a member of the original dataset.
         * </p>
         * 
         * @param membershipInferenceAttackScores
         *        Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which
         *        attempt to determine whether a specific individual was a member of the original dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipInferenceAttackScores(MembershipInferenceAttackScore... membershipInferenceAttackScores);

        /**
         * <p>
         * Scores that evaluate the vulnerability of the synthetic data to membership inference attacks, which attempt
         * to determine whether a specific individual was a member of the original dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.MembershipInferenceAttackScore.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.MembershipInferenceAttackScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.MembershipInferenceAttackScore.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #membershipInferenceAttackScores(List<MembershipInferenceAttackScore>)}.
         * 
         * @param membershipInferenceAttackScores
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.MembershipInferenceAttackScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membershipInferenceAttackScores(java.util.Collection<MembershipInferenceAttackScore>)
         */
        Builder membershipInferenceAttackScores(
                Consumer<MembershipInferenceAttackScore.Builder>... membershipInferenceAttackScores);
    }

    static final class BuilderImpl implements Builder {
        private List<MembershipInferenceAttackScore> membershipInferenceAttackScores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrivacyScores model) {
            membershipInferenceAttackScores(model.membershipInferenceAttackScores);
        }

        public final List<MembershipInferenceAttackScore.Builder> getMembershipInferenceAttackScores() {
            List<MembershipInferenceAttackScore.Builder> result = MembershipInferenceAttackScoreListCopier
                    .copyToBuilder(this.membershipInferenceAttackScores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembershipInferenceAttackScores(
                Collection<MembershipInferenceAttackScore.BuilderImpl> membershipInferenceAttackScores) {
            this.membershipInferenceAttackScores = MembershipInferenceAttackScoreListCopier
                    .copyFromBuilder(membershipInferenceAttackScores);
        }

        @Override
        public final Builder membershipInferenceAttackScores(
                Collection<MembershipInferenceAttackScore> membershipInferenceAttackScores) {
            this.membershipInferenceAttackScores = MembershipInferenceAttackScoreListCopier.copy(membershipInferenceAttackScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipInferenceAttackScores(MembershipInferenceAttackScore... membershipInferenceAttackScores) {
            membershipInferenceAttackScores(Arrays.asList(membershipInferenceAttackScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipInferenceAttackScores(
                Consumer<MembershipInferenceAttackScore.Builder>... membershipInferenceAttackScores) {
            membershipInferenceAttackScores(Stream.of(membershipInferenceAttackScores)
                    .map(c -> MembershipInferenceAttackScore.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataPrivacyScores build() {
            return new DataPrivacyScores(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
