/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainingDatasetRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<CreateTrainingDatasetRequest.Builder, CreateTrainingDatasetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTrainingDatasetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateTrainingDatasetRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Dataset>> TRAINING_DATA_FIELD = SdkField
            .<List<Dataset>> builder(MarshallingType.LIST)
            .memberName("trainingData")
            .getter(getter(CreateTrainingDatasetRequest::trainingData))
            .setter(setter(Builder::trainingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dataset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dataset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateTrainingDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateTrainingDatasetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            TRAINING_DATA_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String roleArn;

    private final List<Dataset> trainingData;

    private final Map<String, String> tags;

    private final String description;

    private CreateTrainingDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.trainingData = builder.trainingData;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the training dataset. This name must be unique in your account and region.
     * </p>
     * 
     * @return The name of the training dataset. This name must be unique in your account and region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the
     * <code>dataSource</code> field of each dataset.
     * </p>
     * <p>
     * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an
     * <code>AccessDeniedException</code> error.
     * </p>
     * 
     * @return The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the
     *         <code>dataSource</code> field of each dataset.</p>
     *         <p>
     *         Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get
     *         an <code>AccessDeniedException</code> error.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainingData() {
        return trainingData != null && !(trainingData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of information that lists the Dataset objects, which specifies the dataset type and details on its
     * location and schema. You must provide a role that has read access to these tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingData} method.
     * </p>
     * 
     * @return An array of information that lists the Dataset objects, which specifies the dataset type and details on
     *         its location and schema. You must provide a role that has read access to these tables.
     */
    public final List<Dataset> trainingData() {
        return trainingData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the training dataset.
     * </p>
     * 
     * @return The description of the training dataset.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingData() ? trainingData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingDatasetRequest)) {
            return false;
        }
        CreateTrainingDatasetRequest other = (CreateTrainingDatasetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && hasTrainingData() == other.hasTrainingData() && Objects.equals(trainingData(), other.trainingData())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrainingDatasetRequest").add("Name", name()).add("RoleArn", roleArn())
                .add("TrainingData", hasTrainingData() ? trainingData() : null).add("Tags", hasTags() ? tags() : null)
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "trainingData":
            return Optional.ofNullable(clazz.cast(trainingData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("trainingData", TRAINING_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingDatasetRequest, T> g) {
        return obj -> g.apply((CreateTrainingDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainingDatasetRequest> {
        /**
         * <p>
         * The name of the training dataset. This name must be unique in your account and region.
         * </p>
         * 
         * @param name
         *        The name of the training dataset. This name must be unique in your account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the
         * <code>dataSource</code> field of each dataset.
         * </p>
         * <p>
         * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an
         * <code>AccessDeniedException</code> error.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the
         *        <code>dataSource</code> field of each dataset.</p>
         *        <p>
         *        Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you
         *        get an <code>AccessDeniedException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of information that lists the Dataset objects, which specifies the dataset type and details on its
         * location and schema. You must provide a role that has read access to these tables.
         * </p>
         * 
         * @param trainingData
         *        An array of information that lists the Dataset objects, which specifies the dataset type and details
         *        on its location and schema. You must provide a role that has read access to these tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(Collection<Dataset> trainingData);

        /**
         * <p>
         * An array of information that lists the Dataset objects, which specifies the dataset type and details on its
         * location and schema. You must provide a role that has read access to these tables.
         * </p>
         * 
         * @param trainingData
         *        An array of information that lists the Dataset objects, which specifies the dataset type and details
         *        on its location and schema. You must provide a role that has read access to these tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(Dataset... trainingData);

        /**
         * <p>
         * An array of information that lists the Dataset objects, which specifies the dataset type and details on its
         * location and schema. You must provide a role that has read access to these tables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder#build()} is called immediately and
         * its result is passed to {@link #trainingData(List<Dataset>)}.
         * 
         * @param trainingData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingData(java.util.Collection<Dataset>)
         */
        Builder trainingData(Consumer<Dataset.Builder>... trainingData);

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the training dataset.
         * </p>
         * 
         * @param description
         *        The description of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String name;

        private String roleArn;

        private List<Dataset> trainingData = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingDatasetRequest model) {
            super(model);
            name(model.name);
            roleArn(model.roleArn);
            trainingData(model.trainingData);
            tags(model.tags);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Dataset.Builder> getTrainingData() {
            List<Dataset.Builder> result = CreateTrainingDatasetRequestTrainingDataListCopier.copyToBuilder(this.trainingData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingData(Collection<Dataset.BuilderImpl> trainingData) {
            this.trainingData = CreateTrainingDatasetRequestTrainingDataListCopier.copyFromBuilder(trainingData);
        }

        @Override
        public final Builder trainingData(Collection<Dataset> trainingData) {
            this.trainingData = CreateTrainingDatasetRequestTrainingDataListCopier.copy(trainingData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Dataset... trainingData) {
            trainingData(Arrays.asList(trainingData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Consumer<Dataset.Builder>... trainingData) {
            trainingData(Stream.of(trainingData).map(c -> Dataset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainingDatasetRequest build() {
            return new CreateTrainingDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
