/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMlInputChannelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<CreateMlInputChannelResponse.Builder, CreateMlInputChannelResponse> {
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlInputChannelArn").getter(getter(CreateMlInputChannelResponse::mlInputChannelArn))
            .setter(setter(Builder::mlInputChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_INPUT_CHANNEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mlInputChannelArn;

    private CreateMlInputChannelResponse(BuilderImpl builder) {
        super(builder);
        this.mlInputChannelArn = builder.mlInputChannelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML input channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML input channel.
     */
    public final String mlInputChannelArn() {
        return mlInputChannelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlInputChannelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlInputChannelResponse)) {
            return false;
        }
        CreateMlInputChannelResponse other = (CreateMlInputChannelResponse) obj;
        return Objects.equals(mlInputChannelArn(), other.mlInputChannelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMlInputChannelResponse").add("MlInputChannelArn", mlInputChannelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mlInputChannelArn":
            return Optional.ofNullable(clazz.cast(mlInputChannelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMlInputChannelResponse, T> g) {
        return obj -> g.apply((CreateMlInputChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMlInputChannelResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML input channel.
         * </p>
         * 
         * @param mlInputChannelArn
         *        The Amazon Resource Name (ARN) of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlInputChannelArn(String mlInputChannelArn);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String mlInputChannelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlInputChannelResponse model) {
            super(model);
            mlInputChannelArn(model.mlInputChannelArn);
        }

        public final String getMlInputChannelArn() {
            return mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        @Override
        public CreateMlInputChannelResponse build() {
            return new CreateMlInputChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
