/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a trained model export job in a collaboration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationTrainedModelExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationTrainedModelExportJobSummary.Builder, CollaborationTrainedModelExportJobSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(CollaborationTrainedModelExportJobSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(CollaborationTrainedModelExportJobSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CollaborationTrainedModelExportJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<TrainedModelExportOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<TrainedModelExportOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(CollaborationTrainedModelExportJobSummary::outputConfiguration))
            .setter(setter(Builder::outputConfiguration)).constructor(TrainedModelExportOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CollaborationTrainedModelExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(CollaborationTrainedModelExportJobSummary::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CollaborationTrainedModelExportJobSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(CollaborationTrainedModelExportJobSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(CollaborationTrainedModelExportJobSummary::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> TRAINED_MODEL_VERSION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainedModelVersionIdentifier")
            .getter(getter(CollaborationTrainedModelExportJobSummary::trainedModelVersionIdentifier))
            .setter(setter(Builder::trainedModelVersionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelVersionIdentifier")
                    .build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CollaborationTrainedModelExportJobSummary::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(CollaborationTrainedModelExportJobSummary::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, NAME_FIELD, OUTPUT_CONFIGURATION_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, DESCRIPTION_FIELD,
            CREATOR_ACCOUNT_ID_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_VERSION_IDENTIFIER_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String name;

    private final TrainedModelExportOutputConfiguration outputConfiguration;

    private final String status;

    private final StatusDetails statusDetails;

    private final String description;

    private final String creatorAccountId;

    private final String trainedModelArn;

    private final String trainedModelVersionIdentifier;

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private CollaborationTrainedModelExportJobSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.outputConfiguration = builder.outputConfiguration;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.description = builder.description;
        this.creatorAccountId = builder.creatorAccountId;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelVersionIdentifier = builder.trainedModelVersionIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
    }

    /**
     * <p>
     * The time at which the trained model export job was created.
     * </p>
     * 
     * @return The time at which the trained model export job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the trained model export job was updated.
     * </p>
     * 
     * @return The most recent time at which the trained model export job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The name of the trained model export job.
     * </p>
     * 
     * @return The name of the trained model export job.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the OutputConfiguration property for this object.
     * 
     * @return The value of the OutputConfiguration property for this object.
     */
    public final TrainedModelExportOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelExportJobStatus
     */
    public final TrainedModelExportJobStatus status() {
        return TrainedModelExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusDetails property for this object.
     * 
     * @return The value of the StatusDetails property for this object.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The description of the trained model.
     * </p>
     * 
     * @return The description of the trained model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The account ID of the member that created the trained model.
     * </p>
     * 
     * @return The account ID of the member that created the trained model.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model that is being exported.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model that is being exported.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of the trained model that was exported in this job.
     * </p>
     * 
     * @return The version identifier of the trained model that was exported in this job.
     */
    public final String trainedModelVersionIdentifier() {
        return trainedModelVersionIdentifier;
    }

    /**
     * <p>
     * The membership ID of the member that created the trained model export job.
     * </p>
     * 
     * @return The membership ID of the member that created the trained model export job.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the trained model export job.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the trained model export job.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationTrainedModelExportJobSummary)) {
            return false;
        }
        CollaborationTrainedModelExportJobSummary other = (CollaborationTrainedModelExportJobSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(name(), other.name()) && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(description(), other.description())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(trainedModelVersionIdentifier(), other.trainedModelVersionIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaborationTrainedModelExportJobSummary").add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("Name", name()).add("OutputConfiguration", outputConfiguration())
                .add("Status", statusAsString()).add("StatusDetails", statusDetails()).add("Description", description())
                .add("CreatorAccountId", creatorAccountId()).add("TrainedModelArn", trainedModelArn())
                .add("TrainedModelVersionIdentifier", trainedModelVersionIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).add("CollaborationIdentifier", collaborationIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "trainedModelVersionIdentifier":
            return Optional.ofNullable(clazz.cast(trainedModelVersionIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("trainedModelVersionIdentifier", TRAINED_MODEL_VERSION_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationTrainedModelExportJobSummary, T> g) {
        return obj -> g.apply((CollaborationTrainedModelExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationTrainedModelExportJobSummary> {
        /**
         * <p>
         * The time at which the trained model export job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the trained model export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the trained model export job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the trained model export job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The name of the trained model export job.
         * </p>
         * 
         * @param name
         *        The name of the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the OutputConfiguration property for this object.
         *
         * @param outputConfiguration
         *        The new value for the OutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(TrainedModelExportOutputConfiguration outputConfiguration);

        /**
         * Sets the value of the OutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link TrainedModelExportOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link TrainedModelExportOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelExportOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(TrainedModelExportOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link TrainedModelExportOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(TrainedModelExportOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<TrainedModelExportOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(TrainedModelExportOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelExportJobStatus
         */
        Builder status(TrainedModelExportJobStatus status);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * @param statusDetails
         *        The new value for the StatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The description of the trained model.
         * </p>
         * 
         * @param description
         *        The description of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The account ID of the member that created the trained model.
         * </p>
         * 
         * @param creatorAccountId
         *        The account ID of the member that created the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model that is being exported.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model that is being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of the trained model that was exported in this job.
         * </p>
         * 
         * @param trainedModelVersionIdentifier
         *        The version identifier of the trained model that was exported in this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier);

        /**
         * <p>
         * The membership ID of the member that created the trained model export job.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that created the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the trained model export job.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the trained model export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String name;

        private TrainedModelExportOutputConfiguration outputConfiguration;

        private String status;

        private StatusDetails statusDetails;

        private String description;

        private String creatorAccountId;

        private String trainedModelArn;

        private String trainedModelVersionIdentifier;

        private String membershipIdentifier;

        private String collaborationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationTrainedModelExportJobSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            name(model.name);
            outputConfiguration(model.outputConfiguration);
            status(model.status);
            statusDetails(model.statusDetails);
            description(model.description);
            creatorAccountId(model.creatorAccountId);
            trainedModelArn(model.trainedModelArn);
            trainedModelVersionIdentifier(model.trainedModelVersionIdentifier);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TrainedModelExportOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(TrainedModelExportOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(TrainedModelExportOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getTrainedModelVersionIdentifier() {
            return trainedModelVersionIdentifier;
        }

        public final void setTrainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
        }

        @Override
        public final Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        @Override
        public CollaborationTrainedModelExportJobSummary build() {
            return new CollaborationTrainedModelExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
