/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelVersionsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher;

/**
 * Service client for accessing AWS Clean Rooms ML asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Welcome to the <i>Amazon Web Services Clean Rooms ML API Reference</i>.
 * </p>
 * <p>
 * Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in
 * their data without the need to share their data with each other. The first party brings the training data to Clean
 * Rooms so that they can create and configure an audience model (lookalike model) and associate it with a
 * collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike
 * segment) that resembles the training data.
 * </p>
 * <p>
 * To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html">Clean Rooms User Guide</a>.
 * </p>
 * <p>
 * To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CleanRoomsMlAsyncClient extends AwsClient {
    String SERVICE_NAME = "cleanrooms-ml";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cleanrooms-ml";

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     *
     * @param cancelTrainedModelRequest
     * @return A Java Future containing the result of the CancelTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTrainedModelResponse> cancelTrainedModel(CancelTrainedModelRequest cancelTrainedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to cancel the trained model job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTrainedModelRequest.Builder} avoiding the
     * need to create one manually via {@link CancelTrainedModelRequest#builder()}
     * </p>
     *
     * @param cancelTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTrainedModelResponse> cancelTrainedModel(
            Consumer<CancelTrainedModelRequest.Builder> cancelTrainedModelRequest) {
        return cancelTrainedModel(CancelTrainedModelRequest.builder().applyMutation(cancelTrainedModelRequest).build());
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the CancelTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTrainedModelInferenceJobResponse> cancelTrainedModelInferenceJob(
            CancelTrainedModelInferenceJobRequest cancelTrainedModelInferenceJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to cancel a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link CancelTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param cancelTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CancelTrainedModelInferenceJobRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CancelTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CancelTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTrainedModelInferenceJobResponse> cancelTrainedModelInferenceJob(
            Consumer<CancelTrainedModelInferenceJobRequest.Builder> cancelTrainedModelInferenceJobRequest) {
        return cancelTrainedModelInferenceJob(CancelTrainedModelInferenceJobRequest.builder()
                .applyMutation(cancelTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return A Java Future containing the result of the CreateAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAudienceModelResponse> createAudienceModel(
            CreateAudienceModelRequest createAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAudienceModelRequest#builder()}
     * </p>
     *
     * @param createAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAudienceModelResponse> createAudienceModel(
            Consumer<CreateAudienceModelRequest.Builder> createAudienceModelRequest) {
        return createAudienceModel(CreateAudienceModelRequest.builder().applyMutation(createAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the CreateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredAudienceModelResponse> createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredAudienceModelResponse> createConfiguredAudienceModel(
            Consumer<CreateConfiguredAudienceModelRequest.Builder> createConfiguredAudienceModelRequest) {
        return createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest.builder()
                .applyMutation(createConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredModelAlgorithmResponse> createConfiguredModelAlgorithm(
            CreateConfiguredModelAlgorithmRequest createConfiguredModelAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configured model algorithm using a container image stored in an ECR repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param createConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredModelAlgorithmResponse> createConfiguredModelAlgorithm(
            Consumer<CreateConfiguredModelAlgorithmRequest.Builder> createConfiguredModelAlgorithmRequest) {
        return createConfiguredModelAlgorithm(CreateConfiguredModelAlgorithmRequest.builder()
                .applyMutation(createConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredModelAlgorithmAssociationResponse> createConfiguredModelAlgorithmAssociation(
            CreateConfiguredModelAlgorithmAssociationRequest createConfiguredModelAlgorithmAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param createConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredModelAlgorithmAssociationResponse> createConfiguredModelAlgorithmAssociation(
            Consumer<CreateConfiguredModelAlgorithmAssociationRequest.Builder> createConfiguredModelAlgorithmAssociationRequest) {
        return createConfiguredModelAlgorithmAssociation(CreateConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(createConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     *
     * @param createMlInputChannelRequest
     * @return A Java Future containing the result of the CreateMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMlInputChannelResponse> createMLInputChannel(
            CreateMlInputChannelRequest createMlInputChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information to create an ML input channel. An ML input channel is the result of a query that can be
     * used for ML modeling.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlInputChannelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMlInputChannelRequest#builder()}
     * </p>
     *
     * @param createMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateMlInputChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMlInputChannelResponse> createMLInputChannel(
            Consumer<CreateMlInputChannelRequest.Builder> createMlInputChannelRequest) {
        return createMLInputChannel(CreateMlInputChannelRequest.builder().applyMutation(createMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     *
     * @param createTrainedModelRequest
     * @return A Java Future containing the result of the CreateTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>InternalServiceException An internal service error occurred. Retry your request. If the problem
     *         persists, contact AWS Support.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainedModelResponse> createTrainedModel(CreateTrainedModelRequest createTrainedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trained model from an associated configured model algorithm using data from any member of the
     * collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainedModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainedModelRequest#builder()}
     * </p>
     *
     * @param createTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainedModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>InternalServiceException An internal service error occurred. Retry your request. If the problem
     *         persists, contact AWS Support.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainedModelResponse> createTrainedModel(
            Consumer<CreateTrainedModelRequest.Builder> createTrainedModelRequest) {
        return createTrainedModel(CreateTrainedModelRequest.builder().applyMutation(createTrainedModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return A Java Future containing the result of the CreateTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainingDatasetResponse> createTrainingDataset(
            CreateTrainingDatasetRequest createTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param createTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainingDatasetResponse> createTrainingDataset(
            Consumer<CreateTrainingDatasetRequest.Builder> createTrainingDatasetRequest) {
        return createTrainingDataset(CreateTrainingDatasetRequest.builder().applyMutation(createTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return A Java Future containing the result of the DeleteAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceGenerationJobResponse> deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceGenerationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceGenerationJobResponse> deleteAudienceGenerationJob(
            Consumer<DeleteAudienceGenerationJobRequest.Builder> deleteAudienceGenerationJobRequest) {
        return deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest.builder()
                .applyMutation(deleteAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return A Java Future containing the result of the DeleteAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceModelResponse> deleteAudienceModel(
            DeleteAudienceModelRequest deleteAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceModelResponse> deleteAudienceModel(
            Consumer<DeleteAudienceModelRequest.Builder> deleteAudienceModelRequest) {
        return deleteAudienceModel(DeleteAudienceModelRequest.builder().applyMutation(deleteAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelResponse> deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelResponse> deleteConfiguredAudienceModel(
            Consumer<DeleteConfiguredAudienceModelRequest.Builder> deleteConfiguredAudienceModelRequest) {
        return deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> deleteConfiguredAudienceModelPolicy(
            Consumer<DeleteConfiguredAudienceModelPolicyRequest.Builder> deleteConfiguredAudienceModelPolicyRequest) {
        return deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredModelAlgorithmResponse> deleteConfiguredModelAlgorithm(
            DeleteConfiguredModelAlgorithmRequest deleteConfiguredModelAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured model algorithm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithm operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredModelAlgorithmResponse> deleteConfiguredModelAlgorithm(
            Consumer<DeleteConfiguredModelAlgorithmRequest.Builder> deleteConfiguredModelAlgorithmRequest) {
        return deleteConfiguredModelAlgorithm(DeleteConfiguredModelAlgorithmRequest.builder()
                .applyMutation(deleteConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredModelAlgorithmAssociationResponse> deleteConfiguredModelAlgorithmAssociation(
            DeleteConfiguredModelAlgorithmAssociationRequest deleteConfiguredModelAlgorithmAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured model algorithm association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConfiguredModelAlgorithmAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredModelAlgorithmAssociationResponse> deleteConfiguredModelAlgorithmAssociation(
            Consumer<DeleteConfiguredModelAlgorithmAssociationRequest.Builder> deleteConfiguredModelAlgorithmAssociationRequest) {
        return deleteConfiguredModelAlgorithmAssociation(DeleteConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(deleteConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     *
     * @param deleteMlConfigurationRequest
     * @return A Java Future containing the result of the DeleteMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlConfigurationResponse> deleteMLConfiguration(
            DeleteMlConfigurationRequest deleteMlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a ML modeling configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMlConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteMlConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlConfigurationResponse> deleteMLConfiguration(
            Consumer<DeleteMlConfigurationRequest.Builder> deleteMlConfigurationRequest) {
        return deleteMLConfiguration(DeleteMlConfigurationRequest.builder().applyMutation(deleteMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     * @return A Java Future containing the result of the DeleteMLInputChannelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlInputChannelDataResponse> deleteMLInputChannelData(
            DeleteMlInputChannelDataRequest deleteMlInputChannelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to delete an ML input channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlInputChannelDataRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMlInputChannelDataRequest#builder()}
     * </p>
     *
     * @param deleteMlInputChannelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteMlInputChannelDataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMLInputChannelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteMLInputChannelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteMLInputChannelData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlInputChannelDataResponse> deleteMLInputChannelData(
            Consumer<DeleteMlInputChannelDataRequest.Builder> deleteMlInputChannelDataRequest) {
        return deleteMLInputChannelData(DeleteMlInputChannelDataRequest.builder().applyMutation(deleteMlInputChannelDataRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the model artifacts stored by the service.
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     * @return A Java Future containing the result of the DeleteTrainedModelOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainedModelOutputResponse> deleteTrainedModelOutput(
            DeleteTrainedModelOutputRequest deleteTrainedModelOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the model artifacts stored by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainedModelOutputRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrainedModelOutputRequest#builder()}
     * </p>
     *
     * @param deleteTrainedModelOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainedModelOutputRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteTrainedModelOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainedModelOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainedModelOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainedModelOutputResponse> deleteTrainedModelOutput(
            Consumer<DeleteTrainedModelOutputRequest.Builder> deleteTrainedModelOutputRequest) {
        return deleteTrainedModelOutput(DeleteTrainedModelOutputRequest.builder().applyMutation(deleteTrainedModelOutputRequest)
                .build());
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return A Java Future containing the result of the DeleteTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingDatasetResponse> deleteTrainingDataset(
            DeleteTrainingDatasetRequest deleteTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingDatasetResponse> deleteTrainingDataset(
            Consumer<DeleteTrainingDatasetRequest.Builder> deleteTrainingDatasetRequest) {
        return deleteTrainingDataset(DeleteTrainingDatasetRequest.builder().applyMutation(deleteTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return A Java Future containing the result of the GetAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAudienceGenerationJobResponse> getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAudienceGenerationJobResponse> getAudienceGenerationJob(
            Consumer<GetAudienceGenerationJobRequest.Builder> getAudienceGenerationJobRequest) {
        return getAudienceGenerationJob(GetAudienceGenerationJobRequest.builder().applyMutation(getAudienceGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return A Java Future containing the result of the GetAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAudienceModelResponse> getAudienceModel(GetAudienceModelRequest getAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetAudienceModelRequest#builder()}
     * </p>
     *
     * @param getAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAudienceModelResponse> getAudienceModel(
            Consumer<GetAudienceModelRequest.Builder> getAudienceModelRequest) {
        return getAudienceModel(GetAudienceModelRequest.builder().applyMutation(getAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the GetCollaborationConfiguredModelAlgorithmAssociation operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationConfiguredModelAlgorithmAssociationResponse> getCollaborationConfiguredModelAlgorithmAssociation(
            GetCollaborationConfiguredModelAlgorithmAssociationRequest getCollaborationConfiguredModelAlgorithmAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configured model algorithm association in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one
     * manually via {@link GetCollaborationConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param getCollaborationConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetCollaborationConfiguredModelAlgorithmAssociation operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationConfiguredModelAlgorithmAssociationResponse> getCollaborationConfiguredModelAlgorithmAssociation(
            Consumer<GetCollaborationConfiguredModelAlgorithmAssociationRequest.Builder> getCollaborationConfiguredModelAlgorithmAssociationRequest) {
        return getCollaborationConfiguredModelAlgorithmAssociation(GetCollaborationConfiguredModelAlgorithmAssociationRequest
                .builder().applyMutation(getCollaborationConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     * @return A Java Future containing the result of the GetCollaborationMLInputChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationMlInputChannelResponse> getCollaborationMLInputChannel(
            GetCollaborationMlInputChannelRequest getCollaborationMlInputChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific ML input channel in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationMlInputChannelRequest.Builder}
     * avoiding the need to create one manually via {@link GetCollaborationMlInputChannelRequest#builder()}
     * </p>
     *
     * @param getCollaborationMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMlInputChannelRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetCollaborationMLInputChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationMlInputChannelResponse> getCollaborationMLInputChannel(
            Consumer<GetCollaborationMlInputChannelRequest.Builder> getCollaborationMlInputChannelRequest) {
        return getCollaborationMLInputChannel(GetCollaborationMlInputChannelRequest.builder()
                .applyMutation(getCollaborationMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     * @return A Java Future containing the result of the GetCollaborationTrainedModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationTrainedModelResponse> getCollaborationTrainedModel(
            GetCollaborationTrainedModelRequest getCollaborationTrainedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationTrainedModelRequest.Builder}
     * avoiding the need to create one manually via {@link GetCollaborationTrainedModelRequest#builder()}
     * </p>
     *
     * @param getCollaborationTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationTrainedModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCollaborationTrainedModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetCollaborationTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetCollaborationTrainedModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCollaborationTrainedModelResponse> getCollaborationTrainedModel(
            Consumer<GetCollaborationTrainedModelRequest.Builder> getCollaborationTrainedModelRequest) {
        return getCollaborationTrainedModel(GetCollaborationTrainedModelRequest.builder()
                .applyMutation(getCollaborationTrainedModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelResponse> getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConfiguredAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelResponse> getConfiguredAudienceModel(
            Consumer<GetConfiguredAudienceModelRequest.Builder> getConfiguredAudienceModelRequest) {
        return getConfiguredAudienceModel(GetConfiguredAudienceModelRequest.builder()
                .applyMutation(getConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelPolicyResponse> getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelPolicyResponse> getConfiguredAudienceModelPolicy(
            Consumer<GetConfiguredAudienceModelPolicyRequest.Builder> getConfiguredAudienceModelPolicyRequest) {
        return getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(getConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredModelAlgorithmResponse> getConfiguredModelAlgorithm(
            GetConfiguredModelAlgorithmRequest getConfiguredModelAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured model algorithm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredModelAlgorithmRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredModelAlgorithmRequest#builder()}
     * </p>
     *
     * @param getConfiguredModelAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredModelAlgorithmResponse> getConfiguredModelAlgorithm(
            Consumer<GetConfiguredModelAlgorithmRequest.Builder> getConfiguredModelAlgorithmRequest) {
        return getConfiguredModelAlgorithm(GetConfiguredModelAlgorithmRequest.builder()
                .applyMutation(getConfiguredModelAlgorithmRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithmAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredModelAlgorithmAssociationResponse> getConfiguredModelAlgorithmAssociation(
            GetConfiguredModelAlgorithmAssociationRequest getConfiguredModelAlgorithmAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured model algorithm association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfiguredModelAlgorithmAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfiguredModelAlgorithmAssociationRequest#builder()}
     * </p>
     *
     * @param getConfiguredModelAlgorithmAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetConfiguredModelAlgorithmAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredModelAlgorithmAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredModelAlgorithmAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredModelAlgorithmAssociationResponse> getConfiguredModelAlgorithmAssociation(
            Consumer<GetConfiguredModelAlgorithmAssociationRequest.Builder> getConfiguredModelAlgorithmAssociationRequest) {
        return getConfiguredModelAlgorithmAssociation(GetConfiguredModelAlgorithmAssociationRequest.builder()
                .applyMutation(getConfiguredModelAlgorithmAssociationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     *
     * @param getMlConfigurationRequest
     * @return A Java Future containing the result of the GetMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlConfigurationResponse> getMLConfiguration(GetMlConfigurationRequest getMlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific ML configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlConfigurationRequest#builder()}
     * </p>
     *
     * @param getMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetMlConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlConfigurationResponse> getMLConfiguration(
            Consumer<GetMlConfigurationRequest.Builder> getMlConfigurationRequest) {
        return getMLConfiguration(GetMlConfigurationRequest.builder().applyMutation(getMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     *
     * @param getMlInputChannelRequest
     * @return A Java Future containing the result of the GetMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlInputChannelResponse> getMLInputChannel(GetMlInputChannelRequest getMlInputChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ML input channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlInputChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlInputChannelRequest#builder()}
     * </p>
     *
     * @param getMlInputChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetMlInputChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMLInputChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetMLInputChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetMLInputChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMlInputChannelResponse> getMLInputChannel(
            Consumer<GetMlInputChannelRequest.Builder> getMlInputChannelRequest) {
        return getMLInputChannel(GetMlInputChannelRequest.builder().applyMutation(getMlInputChannelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     *
     * @param getTrainedModelRequest
     * @return A Java Future containing the result of the GetTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrainedModelResponse> getTrainedModel(GetTrainedModelRequest getTrainedModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainedModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetTrainedModelRequest#builder()}
     * </p>
     *
     * @param getTrainedModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrainedModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrainedModelResponse> getTrainedModel(
            Consumer<GetTrainedModelRequest.Builder> getTrainedModelRequest) {
        return getTrainedModel(GetTrainedModelRequest.builder().applyMutation(getTrainedModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the GetTrainedModelInferenceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainedModelInferenceJobResponse> getTrainedModelInferenceJob(
            GetTrainedModelInferenceJobRequest getTrainedModelInferenceJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link GetTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param getTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainedModelInferenceJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTrainedModelInferenceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainedModelInferenceJobResponse> getTrainedModelInferenceJob(
            Consumer<GetTrainedModelInferenceJobRequest.Builder> getTrainedModelInferenceJobRequest) {
        return getTrainedModelInferenceJob(GetTrainedModelInferenceJobRequest.builder()
                .applyMutation(getTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return A Java Future containing the result of the GetTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainingDatasetResponse> getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param getTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainingDatasetResponse> getTrainingDataset(
            Consumer<GetTrainingDatasetRequest.Builder> getTrainingDatasetRequest) {
        return getTrainingDataset(GetTrainingDatasetRequest.builder().applyMutation(getTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A Java Future containing the result of the ListAudienceExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceExportJobsResponse> listAudienceExportJobs(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAudienceExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceExportJobsResponse> listAudienceExportJobs(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) {
        return listAudienceExportJobs(ListAudienceExportJobsRequest.builder().applyMutation(listAudienceExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsPublisher listAudienceExportJobsPaginator(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) {
        return new ListAudienceExportJobsPublisher(this, listAudienceExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsPublisher listAudienceExportJobsPaginator(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) {
        return listAudienceExportJobsPaginator(ListAudienceExportJobsRequest.builder()
                .applyMutation(listAudienceExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A Java Future containing the result of the ListAudienceGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceGenerationJobsResponse> listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAudienceGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceGenerationJobsResponse> listAudienceGenerationJobs(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) {
        return listAudienceGenerationJobs(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsPublisher listAudienceGenerationJobsPaginator(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) {
        return new ListAudienceGenerationJobsPublisher(this, listAudienceGenerationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsPublisher listAudienceGenerationJobsPaginator(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) {
        return listAudienceGenerationJobsPaginator(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A Java Future containing the result of the ListAudienceModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceModelsResponse> listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAudienceModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceModelsResponse> listAudienceModels(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) {
        return listAudienceModels(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsPublisher listAudienceModelsPaginator(ListAudienceModelsRequest listAudienceModelsRequest) {
        return new ListAudienceModelsPublisher(this, listAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsPublisher listAudienceModelsPaginator(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) {
        return listAudienceModelsPaginator(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return A Java Future containing the result of the ListCollaborationConfiguredModelAlgorithmAssociations
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> listCollaborationConfiguredModelAlgorithmAssociations(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured model algorithm associations in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one
     * manually via {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCollaborationConfiguredModelAlgorithmAssociations
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationConfiguredModelAlgorithmAssociationsResponse> listCollaborationConfiguredModelAlgorithmAssociations(
            Consumer<ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder> listCollaborationConfiguredModelAlgorithmAssociationsRequest) {
        return listCollaborationConfiguredModelAlgorithmAssociations(ListCollaborationConfiguredModelAlgorithmAssociationsRequest
                .builder().applyMutation(listCollaborationConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsPublisher publisher = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsPublisher publisher = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsPublisher listCollaborationConfiguredModelAlgorithmAssociationsPaginator(
            ListCollaborationConfiguredModelAlgorithmAssociationsRequest listCollaborationConfiguredModelAlgorithmAssociationsRequest) {
        return new ListCollaborationConfiguredModelAlgorithmAssociationsPublisher(this,
                listCollaborationConfiguredModelAlgorithmAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsPublisher publisher = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationConfiguredModelAlgorithmAssociationsPublisher publisher = client.listCollaborationConfiguredModelAlgorithmAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one
     * manually via {@link ListCollaborationConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationConfiguredModelAlgorithmAssociationsPublisher listCollaborationConfiguredModelAlgorithmAssociationsPaginator(
            Consumer<ListCollaborationConfiguredModelAlgorithmAssociationsRequest.Builder> listCollaborationConfiguredModelAlgorithmAssociationsRequest) {
        return listCollaborationConfiguredModelAlgorithmAssociationsPaginator(ListCollaborationConfiguredModelAlgorithmAssociationsRequest
                .builder().applyMutation(listCollaborationConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return A Java Future containing the result of the ListCollaborationMLInputChannels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationMlInputChannelsResponse> listCollaborationMLInputChannels(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the ML input channels in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationMlInputChannelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCollaborationMLInputChannels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationMlInputChannelsResponse> listCollaborationMLInputChannels(
            Consumer<ListCollaborationMlInputChannelsRequest.Builder> listCollaborationMlInputChannelsRequest) {
        return listCollaborationMLInputChannels(ListCollaborationMlInputChannelsRequest.builder()
                .applyMutation(listCollaborationMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsPublisher publisher = client.listCollaborationMLInputChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsPublisher publisher = client.listCollaborationMLInputChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMLInputChannelsPublisher listCollaborationMLInputChannelsPaginator(
            ListCollaborationMlInputChannelsRequest listCollaborationMlInputChannelsRequest) {
        return new ListCollaborationMLInputChannelsPublisher(this, listCollaborationMlInputChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsPublisher publisher = client.listCollaborationMLInputChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationMLInputChannelsPublisher publisher = client.listCollaborationMLInputChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationMlInputChannelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationMLInputChannelsPublisher listCollaborationMLInputChannelsPaginator(
            Consumer<ListCollaborationMlInputChannelsRequest.Builder> listCollaborationMlInputChannelsRequest) {
        return listCollaborationMLInputChannelsPaginator(ListCollaborationMlInputChannelsRequest.builder()
                .applyMutation(listCollaborationMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModelExportJobs operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> listCollaborationTrainedModelExportJobs(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the export jobs for a trained model in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelExportJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelExportJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCollaborationTrainedModelExportJobs operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelExportJobsResponse> listCollaborationTrainedModelExportJobs(
            Consumer<ListCollaborationTrainedModelExportJobsRequest.Builder> listCollaborationTrainedModelExportJobsRequest) {
        return listCollaborationTrainedModelExportJobs(ListCollaborationTrainedModelExportJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsPublisher publisher = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsPublisher publisher = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsPublisher listCollaborationTrainedModelExportJobsPaginator(
            ListCollaborationTrainedModelExportJobsRequest listCollaborationTrainedModelExportJobsRequest) {
        return new ListCollaborationTrainedModelExportJobsPublisher(this, listCollaborationTrainedModelExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsPublisher publisher = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelExportJobsPublisher publisher = client.listCollaborationTrainedModelExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelExportJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelExportJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelExportJobsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelExportJobsPublisher listCollaborationTrainedModelExportJobsPaginator(
            Consumer<ListCollaborationTrainedModelExportJobsRequest.Builder> listCollaborationTrainedModelExportJobsRequest) {
        return listCollaborationTrainedModelExportJobsPaginator(ListCollaborationTrainedModelExportJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModelInferenceJobs operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> listCollaborationTrainedModelInferenceJobs(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs in a specified collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelInferenceJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCollaborationTrainedModelInferenceJobs operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelInferenceJobsResponse> listCollaborationTrainedModelInferenceJobs(
            Consumer<ListCollaborationTrainedModelInferenceJobsRequest.Builder> listCollaborationTrainedModelInferenceJobsRequest) {
        return listCollaborationTrainedModelInferenceJobs(ListCollaborationTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsPublisher publisher = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsPublisher publisher = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsPublisher listCollaborationTrainedModelInferenceJobsPaginator(
            ListCollaborationTrainedModelInferenceJobsRequest listCollaborationTrainedModelInferenceJobsRequest) {
        return new ListCollaborationTrainedModelInferenceJobsPublisher(this, listCollaborationTrainedModelInferenceJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsPublisher publisher = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelInferenceJobsPublisher publisher = client.listCollaborationTrainedModelInferenceJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCollaborationTrainedModelInferenceJobsRequest.Builder} avoiding the need to create one manually via
     * {@link ListCollaborationTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelInferenceJobsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModelInferenceJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelInferenceJobsPublisher listCollaborationTrainedModelInferenceJobsPaginator(
            Consumer<ListCollaborationTrainedModelInferenceJobsRequest.Builder> listCollaborationTrainedModelInferenceJobsRequest) {
        return listCollaborationTrainedModelInferenceJobsPaginator(ListCollaborationTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listCollaborationTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return A Java Future containing the result of the ListCollaborationTrainedModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelsResponse> listCollaborationTrainedModels(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the trained models in a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationTrainedModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCollaborationTrainedModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollaborationTrainedModelsResponse> listCollaborationTrainedModels(
            Consumer<ListCollaborationTrainedModelsRequest.Builder> listCollaborationTrainedModelsRequest) {
        return listCollaborationTrainedModels(ListCollaborationTrainedModelsRequest.builder()
                .applyMutation(listCollaborationTrainedModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsPublisher publisher = client.listCollaborationTrainedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsPublisher publisher = client.listCollaborationTrainedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsPublisher listCollaborationTrainedModelsPaginator(
            ListCollaborationTrainedModelsRequest listCollaborationTrainedModelsRequest) {
        return new ListCollaborationTrainedModelsPublisher(this, listCollaborationTrainedModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsPublisher publisher = client.listCollaborationTrainedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListCollaborationTrainedModelsPublisher publisher = client.listCollaborationTrainedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationTrainedModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listCollaborationTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationTrainedModelsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListCollaborationTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListCollaborationTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationTrainedModelsPublisher listCollaborationTrainedModelsPaginator(
            Consumer<ListCollaborationTrainedModelsRequest.Builder> listCollaborationTrainedModelsRequest) {
        return listCollaborationTrainedModelsPaginator(ListCollaborationTrainedModelsRequest.builder()
                .applyMutation(listCollaborationTrainedModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A Java Future containing the result of the ListConfiguredAudienceModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredAudienceModelsResponse> listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConfiguredAudienceModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredAudienceModelsResponse> listConfiguredAudienceModels(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest) {
        return listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsPublisher listConfiguredAudienceModelsPaginator(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) {
        return new ListConfiguredAudienceModelsPublisher(this, listConfiguredAudienceModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsPublisher listConfiguredAudienceModelsPaginator(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest) {
        return listConfiguredAudienceModelsPaginator(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithmAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> listConfiguredModelAlgorithmAssociations(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configured model algorithm associations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithmAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredModelAlgorithmAssociationsResponse> listConfiguredModelAlgorithmAssociations(
            Consumer<ListConfiguredModelAlgorithmAssociationsRequest.Builder> listConfiguredModelAlgorithmAssociationsRequest) {
        return listConfiguredModelAlgorithmAssociations(ListConfiguredModelAlgorithmAssociationsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsPublisher publisher = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsPublisher publisher = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsPublisher listConfiguredModelAlgorithmAssociationsPaginator(
            ListConfiguredModelAlgorithmAssociationsRequest listConfiguredModelAlgorithmAssociationsRequest) {
        return new ListConfiguredModelAlgorithmAssociationsPublisher(this, listConfiguredModelAlgorithmAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsPublisher publisher = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmAssociationsPublisher publisher = client.listConfiguredModelAlgorithmAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithmAssociations(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListConfiguredModelAlgorithmAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListConfiguredModelAlgorithmAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithmAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithmAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmAssociationsPublisher listConfiguredModelAlgorithmAssociationsPaginator(
            Consumer<ListConfiguredModelAlgorithmAssociationsRequest.Builder> listConfiguredModelAlgorithmAssociationsRequest) {
        return listConfiguredModelAlgorithmAssociationsPaginator(ListConfiguredModelAlgorithmAssociationsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithms operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredModelAlgorithmsResponse> listConfiguredModelAlgorithms(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configured model algorithms.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredModelAlgorithmsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredModelAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConfiguredModelAlgorithms operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredModelAlgorithmsResponse> listConfiguredModelAlgorithms(
            Consumer<ListConfiguredModelAlgorithmsRequest.Builder> listConfiguredModelAlgorithmsRequest) {
        return listConfiguredModelAlgorithms(ListConfiguredModelAlgorithmsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsPublisher publisher = client.listConfiguredModelAlgorithmsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsPublisher publisher = client.listConfiguredModelAlgorithmsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsPublisher listConfiguredModelAlgorithmsPaginator(
            ListConfiguredModelAlgorithmsRequest listConfiguredModelAlgorithmsRequest) {
        return new ListConfiguredModelAlgorithmsPublisher(this, listConfiguredModelAlgorithmsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsPublisher publisher = client.listConfiguredModelAlgorithmsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredModelAlgorithmsPublisher publisher = client.listConfiguredModelAlgorithmsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredModelAlgorithms(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredModelAlgorithmsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredModelAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listConfiguredModelAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredModelAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredModelAlgorithms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredModelAlgorithmsPublisher listConfiguredModelAlgorithmsPaginator(
            Consumer<ListConfiguredModelAlgorithmsRequest.Builder> listConfiguredModelAlgorithmsRequest) {
        return listConfiguredModelAlgorithmsPaginator(ListConfiguredModelAlgorithmsRequest.builder()
                .applyMutation(listConfiguredModelAlgorithmsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return A Java Future containing the result of the ListMLInputChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlInputChannelsResponse> listMLInputChannels(
            ListMlInputChannelsRequest listMlInputChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ML input channels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlInputChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMLInputChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMlInputChannelsResponse> listMLInputChannels(
            Consumer<ListMlInputChannelsRequest.Builder> listMlInputChannelsRequest) {
        return listMLInputChannels(ListMlInputChannelsRequest.builder().applyMutation(listMlInputChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsPublisher publisher = client.listMLInputChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsPublisher publisher = client.listMLInputChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMlInputChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMLInputChannelsPublisher listMLInputChannelsPaginator(ListMlInputChannelsRequest listMlInputChannelsRequest) {
        return new ListMLInputChannelsPublisher(this, listMlInputChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsPublisher publisher = client.listMLInputChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListMLInputChannelsPublisher publisher = client.listMLInputChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLInputChannels(software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlInputChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMlInputChannelsRequest#builder()}
     * </p>
     *
     * @param listMlInputChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListMlInputChannelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListMLInputChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListMLInputChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMLInputChannelsPublisher listMLInputChannelsPaginator(
            Consumer<ListMlInputChannelsRequest.Builder> listMlInputChannelsRequest) {
        return listMLInputChannelsPaginator(ListMlInputChannelsRequest.builder().applyMutation(listMlInputChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return A Java Future containing the result of the ListTrainedModelInferenceJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelInferenceJobsResponse> listTrainedModelInferenceJobs(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained model inference jobs that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelInferenceJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTrainedModelInferenceJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelInferenceJobsResponse> listTrainedModelInferenceJobs(
            Consumer<ListTrainedModelInferenceJobsRequest.Builder> listTrainedModelInferenceJobsRequest) {
        return listTrainedModelInferenceJobs(ListTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsPublisher publisher = client.listTrainedModelInferenceJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsPublisher publisher = client.listTrainedModelInferenceJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsPublisher listTrainedModelInferenceJobsPaginator(
            ListTrainedModelInferenceJobsRequest listTrainedModelInferenceJobsRequest) {
        return new ListTrainedModelInferenceJobsPublisher(this, listTrainedModelInferenceJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsPublisher publisher = client.listTrainedModelInferenceJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelInferenceJobsPublisher publisher = client.listTrainedModelInferenceJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelInferenceJobs(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelInferenceJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTrainedModelInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelInferenceJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelInferenceJobsPublisher listTrainedModelInferenceJobsPaginator(
            Consumer<ListTrainedModelInferenceJobsRequest.Builder> listTrainedModelInferenceJobsRequest) {
        return listTrainedModelInferenceJobsPaginator(ListTrainedModelInferenceJobsRequest.builder()
                .applyMutation(listTrainedModelInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained model versions for a specified trained model. This operation allows you to view all
     * versions of a trained model, including information about their status and creation details. You can use this to
     * track the evolution of your trained models and select specific versions for inference or further training.
     * </p>
     *
     * @param listTrainedModelVersionsRequest
     * @return A Java Future containing the result of the ListTrainedModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelVersionsResponse> listTrainedModelVersions(
            ListTrainedModelVersionsRequest listTrainedModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained model versions for a specified trained model. This operation allows you to view all
     * versions of a trained model, including information about their status and creation details. You can use this to
     * track the evolution of your trained models and select specific versions for inference or further training.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrainedModelVersionsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTrainedModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelVersionsResponse> listTrainedModelVersions(
            Consumer<ListTrainedModelVersionsRequest.Builder> listTrainedModelVersionsRequest) {
        return listTrainedModelVersions(ListTrainedModelVersionsRequest.builder().applyMutation(listTrainedModelVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelVersions(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelVersionsPublisher publisher = client.listTrainedModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelVersionsPublisher publisher = client.listTrainedModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelVersions(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainedModelVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelVersionsPublisher listTrainedModelVersionsPaginator(
            ListTrainedModelVersionsRequest listTrainedModelVersionsRequest) {
        return new ListTrainedModelVersionsPublisher(this, listTrainedModelVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModelVersions(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelVersionsPublisher publisher = client.listTrainedModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelVersionsPublisher publisher = client.listTrainedModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModelVersions(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrainedModelVersionsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelVersionsPublisher listTrainedModelVersionsPaginator(
            Consumer<ListTrainedModelVersionsRequest.Builder> listTrainedModelVersionsRequest) {
        return listTrainedModelVersionsPaginator(ListTrainedModelVersionsRequest.builder()
                .applyMutation(listTrainedModelVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return A Java Future containing the result of the ListTrainedModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelsResponse> listTrainedModels(ListTrainedModelsRequest listTrainedModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of trained models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrainedModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainedModelsResponse> listTrainedModels(
            Consumer<ListTrainedModelsRequest.Builder> listTrainedModelsRequest) {
        return listTrainedModels(ListTrainedModelsRequest.builder().applyMutation(listTrainedModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsPublisher publisher = client.listTrainedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsPublisher publisher = client.listTrainedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainedModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsPublisher listTrainedModelsPaginator(ListTrainedModelsRequest listTrainedModelsRequest) {
        return new ListTrainedModelsPublisher(this, listTrainedModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsPublisher publisher = client.listTrainedModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainedModelsPublisher publisher = client.listTrainedModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainedModels(software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainedModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainedModelsRequest#builder()}
     * </p>
     *
     * @param listTrainedModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainedModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainedModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainedModelsPublisher listTrainedModelsPaginator(
            Consumer<ListTrainedModelsRequest.Builder> listTrainedModelsRequest) {
        return listTrainedModelsPaginator(ListTrainedModelsRequest.builder().applyMutation(listTrainedModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A Java Future containing the result of the ListTrainingDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainingDatasetsResponse> listTrainingDatasets(
            ListTrainingDatasetsRequest listTrainingDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrainingDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainingDatasetsResponse> listTrainingDatasets(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) {
        return listTrainingDatasets(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsPublisher listTrainingDatasetsPaginator(ListTrainingDatasetsRequest listTrainingDatasetsRequest) {
        return new ListTrainingDatasetsPublisher(this, listTrainingDatasetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsPublisher listTrainingDatasetsPaginator(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) {
        return listTrainingDatasetsPaginator(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the PutConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfiguredAudienceModelPolicyResponse> putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfiguredAudienceModelPolicyResponse> putConfiguredAudienceModelPolicy(
            Consumer<PutConfiguredAudienceModelPolicyRequest.Builder> putConfiguredAudienceModelPolicyRequest) {
        return putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(putConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     *
     * @param putMlConfigurationRequest
     * @return A Java Future containing the result of the PutMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMlConfigurationResponse> putMLConfiguration(PutMlConfigurationRequest putMlConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns information about an ML configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMlConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link PutMlConfigurationRequest#builder()}
     * </p>
     *
     * @param putMlConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutMlConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutMLConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutMLConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutMLConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMlConfigurationResponse> putMLConfiguration(
            Consumer<PutMlConfigurationRequest.Builder> putMlConfigurationRequest) {
        return putMLConfiguration(PutMlConfigurationRequest.builder().applyMutation(putMlConfigurationRequest).build());
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return A Java Future containing the result of the StartAudienceExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceExportJobResponse> startAudienceExportJob(
            StartAudienceExportJobRequest startAudienceExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartAudienceExportJobRequest#builder()}
     * </p>
     *
     * @param startAudienceExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartAudienceExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceExportJobResponse> startAudienceExportJob(
            Consumer<StartAudienceExportJobRequest.Builder> startAudienceExportJobRequest) {
        return startAudienceExportJob(StartAudienceExportJobRequest.builder().applyMutation(startAudienceExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return A Java Future containing the result of the StartAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceGenerationJobResponse> startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceGenerationJobResponse> startAudienceGenerationJob(
            Consumer<StartAudienceGenerationJobRequest.Builder> startAudienceGenerationJobRequest) {
        return startAudienceGenerationJob(StartAudienceGenerationJobRequest.builder()
                .applyMutation(startAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     * @return A Java Future containing the result of the StartTrainedModelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTrainedModelExportJobResponse> startTrainedModelExportJob(
            StartTrainedModelExportJobRequest startTrainedModelExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to start a trained model export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTrainedModelExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTrainedModelExportJobRequest#builder()}
     * </p>
     *
     * @param startTrainedModelExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelExportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartTrainedModelExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTrainedModelExportJobResponse> startTrainedModelExportJob(
            Consumer<StartTrainedModelExportJobRequest.Builder> startTrainedModelExportJobRequest) {
        return startTrainedModelExportJob(StartTrainedModelExportJobRequest.builder()
                .applyMutation(startTrainedModelExportJobRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     * @return A Java Future containing the result of the StartTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTrainedModelInferenceJobResponse> startTrainedModelInferenceJob(
            StartTrainedModelInferenceJobRequest startTrainedModelInferenceJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to begin a trained model inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTrainedModelInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartTrainedModelInferenceJobRequest#builder()}
     * </p>
     *
     * @param startTrainedModelInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartTrainedModelInferenceJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartTrainedModelInferenceJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartTrainedModelInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartTrainedModelInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTrainedModelInferenceJobResponse> startTrainedModelInferenceJob(
            Consumer<StartTrainedModelInferenceJobRequest.Builder> startTrainedModelInferenceJobRequest) {
        return startTrainedModelInferenceJob(StartTrainedModelInferenceJobRequest.builder()
                .applyMutation(startTrainedModelInferenceJobRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfiguredAudienceModelResponse> updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException You can't complete this action because another resource depends on this resource.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfiguredAudienceModelResponse> updateConfiguredAudienceModel(
            Consumer<UpdateConfiguredAudienceModelRequest.Builder> updateConfiguredAudienceModelRequest) {
        return updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest.builder()
                .applyMutation(updateConfiguredAudienceModelRequest).build());
    }

    @Override
    default CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CleanRoomsMlAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CleanRoomsMlAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CleanRoomsMlAsyncClient}.
     */
    static CleanRoomsMlAsyncClientBuilder builder() {
        return new DefaultCleanRoomsMlAsyncClientBuilder();
    }
}
