/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainedModelVersionsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary;

public class ListTrainedModelVersionsIterable
implements SdkIterable<ListTrainedModelVersionsResponse> {
    private final CleanRoomsMlClient client;
    private final ListTrainedModelVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainedModelVersionsIterable(CleanRoomsMlClient client, ListTrainedModelVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainedModelVersionsResponseFetcher();
    }

    public Iterator<ListTrainedModelVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainedModelSummary> trainedModels() {
        Function<ListTrainedModelVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainedModels() != null) {
                return response.trainedModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainedModelVersionsResponseFetcher
    implements SyncPageFetcher<ListTrainedModelVersionsResponse> {
        private ListTrainedModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainedModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainedModelVersionsResponse nextPage(ListTrainedModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainedModelVersionsIterable.this.client.listTrainedModelVersions(ListTrainedModelVersionsIterable.this.firstRequest);
            }
            return ListTrainedModelVersionsIterable.this.client.listTrainedModelVersions((ListTrainedModelVersionsRequest)((Object)ListTrainedModelVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

