/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetSummary;

public class ListTrainingDatasetsIterable
implements SdkIterable<ListTrainingDatasetsResponse> {
    private final CleanRoomsMlClient client;
    private final ListTrainingDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainingDatasetsIterable(CleanRoomsMlClient client, ListTrainingDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainingDatasetsResponseFetcher();
    }

    public Iterator<ListTrainingDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainingDatasetSummary> trainingDatasets() {
        Function<ListTrainingDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingDatasets() != null) {
                return response.trainingDatasets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainingDatasetsResponseFetcher
    implements SyncPageFetcher<ListTrainingDatasetsResponse> {
        private ListTrainingDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainingDatasetsResponse nextPage(ListTrainingDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingDatasetsIterable.this.client.listTrainingDatasets(ListTrainingDatasetsIterable.this.firstRequest);
            }
            return ListTrainingDatasetsIterable.this.client.listTrainingDatasets((ListTrainingDatasetsRequest)((Object)ListTrainingDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

