/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSizeConfig;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelStatus;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.SharedAudienceMetrics;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TagOnCreatePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfiguredAudienceModelResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetConfiguredAudienceModelResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::createTime)).setter(GetConfiguredAudienceModelResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::updateTime)).setter(GetConfiguredAudienceModelResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::configuredAudienceModelArn)).setter(GetConfiguredAudienceModelResponse.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::name)).setter(GetConfiguredAudienceModelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::audienceModelArn)).setter(GetConfiguredAudienceModelResponse.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::outputConfig)).setter(GetConfiguredAudienceModelResponse.setter(Builder::outputConfig)).constructor(ConfiguredAudienceModelOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::description)).setter(GetConfiguredAudienceModelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::statusAsString)).setter(GetConfiguredAudienceModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sharedAudienceMetrics").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::sharedAudienceMetricsAsStrings)).setter(GetConfiguredAudienceModelResponse.setter(Builder::sharedAudienceMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minMatchingSeedSize").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::minMatchingSeedSize)).setter(GetConfiguredAudienceModelResponse.setter(Builder::minMatchingSeedSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build()}).build();
    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audienceSizeConfig").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::audienceSizeConfig)).setter(GetConfiguredAudienceModelResponse.setter(Builder::audienceSizeConfig)).constructor(AudienceSizeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::tags)).setter(GetConfiguredAudienceModelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("childResourceTagOnCreatePolicy").getter(GetConfiguredAudienceModelResponse.getter(GetConfiguredAudienceModelResponse::childResourceTagOnCreatePolicyAsString)).setter(GetConfiguredAudienceModelResponse.setter(Builder::childResourceTagOnCreatePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childResourceTagOnCreatePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, NAME_FIELD, AUDIENCE_MODEL_ARN_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SHARED_AUDIENCE_METRICS_FIELD, MIN_MATCHING_SEED_SIZE_FIELD, AUDIENCE_SIZE_CONFIG_FIELD, TAGS_FIELD, CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConfiguredAudienceModelResponse.memberNameToFieldInitializer();
    private final Instant createTime;
    private final Instant updateTime;
    private final String configuredAudienceModelArn;
    private final String name;
    private final String audienceModelArn;
    private final ConfiguredAudienceModelOutputConfig outputConfig;
    private final String description;
    private final String status;
    private final List<String> sharedAudienceMetrics;
    private final Integer minMatchingSeedSize;
    private final AudienceSizeConfig audienceSizeConfig;
    private final Map<String, String> tags;
    private final String childResourceTagOnCreatePolicy;

    private GetConfiguredAudienceModelResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.name = builder.name;
        this.audienceModelArn = builder.audienceModelArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.status = builder.status;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.tags = builder.tags;
        this.childResourceTagOnCreatePolicy = builder.childResourceTagOnCreatePolicy;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String description() {
        return this.description;
    }

    public final ConfiguredAudienceModelStatus status() {
        return ConfiguredAudienceModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(this.sharedAudienceMetrics);
    }

    public final boolean hasSharedAudienceMetrics() {
        return this.sharedAudienceMetrics != null && !(this.sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> sharedAudienceMetricsAsStrings() {
        return this.sharedAudienceMetrics;
    }

    public final Integer minMatchingSeedSize() {
        return this.minMatchingSeedSize;
    }

    public final AudienceSizeConfig audienceSizeConfig() {
        return this.audienceSizeConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TagOnCreatePolicy childResourceTagOnCreatePolicy() {
        return TagOnCreatePolicy.fromValue(this.childResourceTagOnCreatePolicy);
    }

    public final String childResourceTagOnCreatePolicyAsString() {
        return this.childResourceTagOnCreatePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.childResourceTagOnCreatePolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredAudienceModelResponse)) {
            return false;
        }
        GetConfiguredAudienceModelResponse other = (GetConfiguredAudienceModelResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics() && Objects.equals(this.sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings()) && Objects.equals(this.minMatchingSeedSize(), other.minMatchingSeedSize()) && Objects.equals(this.audienceSizeConfig(), other.audienceSizeConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.childResourceTagOnCreatePolicyAsString(), other.childResourceTagOnCreatePolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConfiguredAudienceModelResponse").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("Name", (Object)this.name()).add("AudienceModelArn", (Object)this.audienceModelArn()).add("OutputConfig", (Object)this.outputConfig()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("SharedAudienceMetrics", this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null).add("MinMatchingSeedSize", (Object)this.minMatchingSeedSize()).add("AudienceSizeConfig", (Object)this.audienceSizeConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("ChildResourceTagOnCreatePolicy", (Object)this.childResourceTagOnCreatePolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sharedAudienceMetrics": {
                return Optional.ofNullable(clazz.cast(this.sharedAudienceMetricsAsStrings()));
            }
            case "minMatchingSeedSize": {
                return Optional.ofNullable(clazz.cast(this.minMatchingSeedSize()));
            }
            case "audienceSizeConfig": {
                return Optional.ofNullable(clazz.cast(this.audienceSizeConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "childResourceTagOnCreatePolicy": {
                return Optional.ofNullable(clazz.cast(this.childResourceTagOnCreatePolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("audienceModelArn", AUDIENCE_MODEL_ARN_FIELD);
        map.put("outputConfig", OUTPUT_CONFIG_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sharedAudienceMetrics", SHARED_AUDIENCE_METRICS_FIELD);
        map.put("minMatchingSeedSize", MIN_MATCHING_SEED_SIZE_FIELD);
        map.put("audienceSizeConfig", AUDIENCE_SIZE_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("childResourceTagOnCreatePolicy", CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredAudienceModelResponse, T> g) {
        return obj -> g.apply((GetConfiguredAudienceModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String configuredAudienceModelArn;
        private String name;
        private String audienceModelArn;
        private ConfiguredAudienceModelOutputConfig outputConfig;
        private String description;
        private String status;
        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();
        private Integer minMatchingSeedSize;
        private AudienceSizeConfig audienceSizeConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String childResourceTagOnCreatePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredAudienceModelResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.name(model.name);
            this.audienceModelArn(model.audienceModelArn);
            this.outputConfig(model.outputConfig);
            this.description(model.description);
            this.status(model.status);
            this.sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
            this.minMatchingSeedSize(model.minMatchingSeedSize);
            this.audienceSizeConfig(model.audienceSizeConfig);
            this.tags(model.tags);
            this.childResourceTagOnCreatePolicy(model.childResourceTagOnCreatePolicy);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfiguredAudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (this.sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String ... sharedAudienceMetrics) {
            this.sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics ... sharedAudienceMetrics) {
            this.sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return this.minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return this.audienceSizeConfig != null ? this.audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getChildResourceTagOnCreatePolicy() {
            return this.childResourceTagOnCreatePolicy;
        }

        public final void setChildResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
            return this;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy(childResourceTagOnCreatePolicy == null ? null : childResourceTagOnCreatePolicy.toString());
            return this;
        }

        @Override
        public GetConfiguredAudienceModelResponse build() {
            return new GetConfiguredAudienceModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfiguredAudienceModelResponse> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder name(String var1);

        public Builder audienceModelArn(String var1);

        public Builder outputConfig(ConfiguredAudienceModelOutputConfig var1);

        default public Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ConfiguredAudienceModelOutputConfig)((ConfiguredAudienceModelOutputConfig.Builder)ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ConfiguredAudienceModelStatus var1);

        public Builder sharedAudienceMetricsWithStrings(Collection<String> var1);

        public Builder sharedAudienceMetricsWithStrings(String ... var1);

        public Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> var1);

        public Builder sharedAudienceMetrics(SharedAudienceMetrics ... var1);

        public Builder minMatchingSeedSize(Integer var1);

        public Builder audienceSizeConfig(AudienceSizeConfig var1);

        default public Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return this.audienceSizeConfig((AudienceSizeConfig)((AudienceSizeConfig.Builder)AudienceSizeConfig.builder().applyMutation(audienceSizeConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder childResourceTagOnCreatePolicy(String var1);

        public Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy var1);
    }
}

