/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportFileType;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportFileTypeListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportsMaxSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainedModelExportsConfigurationPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainedModelExportsConfigurationPolicy> {
    private static final SdkField<TrainedModelExportsMaxSize> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maxSize").getter(TrainedModelExportsConfigurationPolicy.getter(TrainedModelExportsConfigurationPolicy::maxSize)).setter(TrainedModelExportsConfigurationPolicy.setter(Builder::maxSize)).constructor(TrainedModelExportsMaxSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()}).build();
    private static final SdkField<List<String>> FILES_TO_EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filesToExport").getter(TrainedModelExportsConfigurationPolicy.getter(TrainedModelExportsConfigurationPolicy::filesToExportAsStrings)).setter(TrainedModelExportsConfigurationPolicy.setter(Builder::filesToExportWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesToExport").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_SIZE_FIELD, FILES_TO_EXPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainedModelExportsConfigurationPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TrainedModelExportsMaxSize maxSize;
    private final List<String> filesToExport;

    private TrainedModelExportsConfigurationPolicy(BuilderImpl builder) {
        this.maxSize = builder.maxSize;
        this.filesToExport = builder.filesToExport;
    }

    public final TrainedModelExportsMaxSize maxSize() {
        return this.maxSize;
    }

    public final List<TrainedModelExportFileType> filesToExport() {
        return TrainedModelExportFileTypeListCopier.copyStringToEnum(this.filesToExport);
    }

    public final boolean hasFilesToExport() {
        return this.filesToExport != null && !(this.filesToExport instanceof SdkAutoConstructList);
    }

    public final List<String> filesToExportAsStrings() {
        return this.filesToExport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilesToExport() ? this.filesToExportAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelExportsConfigurationPolicy)) {
            return false;
        }
        TrainedModelExportsConfigurationPolicy other = (TrainedModelExportsConfigurationPolicy)obj;
        return Objects.equals(this.maxSize(), other.maxSize()) && this.hasFilesToExport() == other.hasFilesToExport() && Objects.equals(this.filesToExportAsStrings(), other.filesToExportAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TrainedModelExportsConfigurationPolicy").add("MaxSize", (Object)this.maxSize()).add("FilesToExport", this.hasFilesToExport() ? this.filesToExportAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "filesToExport": {
                return Optional.ofNullable(clazz.cast(this.filesToExportAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("filesToExport", FILES_TO_EXPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelExportsConfigurationPolicy, T> g) {
        return obj -> g.apply((TrainedModelExportsConfigurationPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainedModelExportsMaxSize maxSize;
        private List<String> filesToExport = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelExportsConfigurationPolicy model) {
            this.maxSize(model.maxSize);
            this.filesToExportWithStrings(model.filesToExport);
        }

        public final TrainedModelExportsMaxSize.Builder getMaxSize() {
            return this.maxSize != null ? this.maxSize.toBuilder() : null;
        }

        public final void setMaxSize(TrainedModelExportsMaxSize.BuilderImpl maxSize) {
            this.maxSize = maxSize != null ? maxSize.build() : null;
        }

        @Override
        public final Builder maxSize(TrainedModelExportsMaxSize maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Collection<String> getFilesToExport() {
            if (this.filesToExport instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filesToExport;
        }

        public final void setFilesToExport(Collection<String> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copy(filesToExport);
        }

        @Override
        public final Builder filesToExportWithStrings(Collection<String> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copy(filesToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesToExportWithStrings(String ... filesToExport) {
            this.filesToExportWithStrings(Arrays.asList(filesToExport));
            return this;
        }

        @Override
        public final Builder filesToExport(Collection<TrainedModelExportFileType> filesToExport) {
            this.filesToExport = TrainedModelExportFileTypeListCopier.copyEnumToString(filesToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesToExport(TrainedModelExportFileType ... filesToExport) {
            this.filesToExport(Arrays.asList(filesToExport));
            return this;
        }

        public TrainedModelExportsConfigurationPolicy build() {
            return new TrainedModelExportsConfigurationPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainedModelExportsConfigurationPolicy> {
        public Builder maxSize(TrainedModelExportsMaxSize var1);

        default public Builder maxSize(Consumer<TrainedModelExportsMaxSize.Builder> maxSize) {
            return this.maxSize((TrainedModelExportsMaxSize)((TrainedModelExportsMaxSize.Builder)TrainedModelExportsMaxSize.builder().applyMutation(maxSize)).build());
        }

        public Builder filesToExportWithStrings(Collection<String> var1);

        public Builder filesToExportWithStrings(String ... var1);

        public Builder filesToExport(Collection<TrainedModelExportFileType> var1);

        public Builder filesToExport(TrainedModelExportFileType ... var1);
    }
}

