/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredModelAlgorithmsResponse;

public class ListConfiguredModelAlgorithmsPublisher
implements SdkPublisher<ListConfiguredModelAlgorithmsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListConfiguredModelAlgorithmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredModelAlgorithmsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredModelAlgorithmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredModelAlgorithmsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredModelAlgorithmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredModelAlgorithmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredModelAlgorithmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredModelAlgorithmSummary> configuredModelAlgorithms() {
        Function<ListConfiguredModelAlgorithmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredModelAlgorithms() != null) {
                return response.configuredModelAlgorithms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredModelAlgorithmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredModelAlgorithmsResponseFetcher
    implements AsyncPageFetcher<ListConfiguredModelAlgorithmsResponse> {
        private ListConfiguredModelAlgorithmsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredModelAlgorithmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredModelAlgorithmsResponse> nextPage(ListConfiguredModelAlgorithmsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredModelAlgorithmsPublisher.this.client.listConfiguredModelAlgorithms(ListConfiguredModelAlgorithmsPublisher.this.firstRequest);
            }
            return ListConfiguredModelAlgorithmsPublisher.this.client.listConfiguredModelAlgorithms((ListConfiguredModelAlgorithmsRequest)((Object)ListConfiguredModelAlgorithmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

