/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationMLInputChannelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;

public class ListCollaborationMLInputChannelsIterable
implements SdkIterable<ListCollaborationMlInputChannelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListCollaborationMlInputChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationMLInputChannelsIterable(CleanRoomsMlClient client, ListCollaborationMlInputChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationMlInputChannelsResponseFetcher();
    }

    public Iterator<ListCollaborationMlInputChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList() {
        Function<ListCollaborationMlInputChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationMLInputChannelsList() != null) {
                return response.collaborationMLInputChannelsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationMlInputChannelsResponseFetcher
    implements SyncPageFetcher<ListCollaborationMlInputChannelsResponse> {
        private ListCollaborationMlInputChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationMlInputChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationMlInputChannelsResponse nextPage(ListCollaborationMlInputChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationMLInputChannelsIterable.this.client.listCollaborationMLInputChannels(ListCollaborationMLInputChannelsIterable.this.firstRequest);
            }
            return ListCollaborationMLInputChannelsIterable.this.client.listCollaborationMLInputChannels((ListCollaborationMlInputChannelsRequest)((Object)ListCollaborationMLInputChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

