/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelStatus;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MLInputChannelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MLInputChannelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(MLInputChannelSummary.getter(MLInputChannelSummary::createTime)).setter(MLInputChannelSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(MLInputChannelSummary.getter(MLInputChannelSummary::updateTime)).setter(MLInputChannelSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(MLInputChannelSummary.getter(MLInputChannelSummary::membershipIdentifier)).setter(MLInputChannelSummary.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(MLInputChannelSummary.getter(MLInputChannelSummary::collaborationIdentifier)).setter(MLInputChannelSummary.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MLInputChannelSummary.getter(MLInputChannelSummary::name)).setter(MLInputChannelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithmAssociations").getter(MLInputChannelSummary.getter(MLInputChannelSummary::configuredModelAlgorithmAssociations)).setter(MLInputChannelSummary.setter(Builder::configuredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTECTED_QUERY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protectedQueryIdentifier").getter(MLInputChannelSummary.getter(MLInputChannelSummary::protectedQueryIdentifier)).setter(MLInputChannelSummary.setter(Builder::protectedQueryIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueryIdentifier").build()}).build();
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlInputChannelArn").getter(MLInputChannelSummary.getter(MLInputChannelSummary::mlInputChannelArn)).setter(MLInputChannelSummary.setter(Builder::mlInputChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MLInputChannelSummary.getter(MLInputChannelSummary::statusAsString)).setter(MLInputChannelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(MLInputChannelSummary.getter(MLInputChannelSummary::description)).setter(MLInputChannelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, PROTECTED_QUERY_IDENTIFIER_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MLInputChannelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final String name;
    private final List<String> configuredModelAlgorithmAssociations;
    private final String protectedQueryIdentifier;
    private final String mlInputChannelArn;
    private final String status;
    private final String description;

    private MLInputChannelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.protectedQueryIdentifier = builder.protectedQueryIdentifier;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.status = builder.status;
        this.description = builder.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations != null && !(this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<String> configuredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations;
    }

    public final String protectedQueryIdentifier() {
        return this.protectedQueryIdentifier;
    }

    public final String mlInputChannelArn() {
        return this.mlInputChannelArn;
    }

    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedQueryIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLInputChannelSummary)) {
            return false;
        }
        MLInputChannelSummary other = (MLInputChannelSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.name(), other.name()) && this.hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations() && Objects.equals(this.configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations()) && Objects.equals(this.protectedQueryIdentifier(), other.protectedQueryIdentifier()) && Objects.equals(this.mlInputChannelArn(), other.mlInputChannelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"MLInputChannelSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("Name", (Object)this.name()).add("ConfiguredModelAlgorithmAssociations", this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null).add("ProtectedQueryIdentifier", (Object)this.protectedQueryIdentifier()).add("MlInputChannelArn", (Object)this.mlInputChannelArn()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociations()));
            }
            case "protectedQueryIdentifier": {
                return Optional.ofNullable(clazz.cast(this.protectedQueryIdentifier()));
            }
            case "mlInputChannelArn": {
                return Optional.ofNullable(clazz.cast(this.mlInputChannelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        map.put("protectedQueryIdentifier", PROTECTED_QUERY_IDENTIFIER_FIELD);
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLInputChannelSummary, T> g) {
        return obj -> g.apply((MLInputChannelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private String name;
        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();
        private String protectedQueryIdentifier;
        private String mlInputChannelArn;
        private String status;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(MLInputChannelSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.name(model.name);
            this.configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            this.protectedQueryIdentifier(model.protectedQueryIdentifier);
            this.mlInputChannelArn(model.mlInputChannelArn);
            this.status(model.status);
            this.description(model.description);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = MLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = MLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String ... configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getProtectedQueryIdentifier() {
            return this.protectedQueryIdentifier;
        }

        public final void setProtectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
        }

        @Override
        public final Builder protectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
            return this;
        }

        public final String getMlInputChannelArn() {
            return this.mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public MLInputChannelSummary build() {
            return new MLInputChannelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MLInputChannelSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder name(String var1);

        public Builder configuredModelAlgorithmAssociations(Collection<String> var1);

        public Builder configuredModelAlgorithmAssociations(String ... var1);

        public Builder protectedQueryIdentifier(String var1);

        public Builder mlInputChannelArn(String var1);

        public Builder status(String var1);

        public Builder status(MLInputChannelStatus var1);

        public Builder description(String var1);
    }
}

