/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ContainerConfig;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceContainerConfig;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredModelAlgorithmRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CreateConfiguredModelAlgorithmRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::name)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::description)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::roleArn)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ContainerConfig> TRAINING_CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingContainerConfig").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::trainingContainerConfig)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::trainingContainerConfig)).constructor(ContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingContainerConfig").build()}).build();
    private static final SdkField<InferenceContainerConfig> INFERENCE_CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceContainerConfig").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::inferenceContainerConfig)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::inferenceContainerConfig)).constructor(InferenceContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceContainerConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::tags)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateConfiguredModelAlgorithmRequest.getter(CreateConfiguredModelAlgorithmRequest::kmsKeyArn)).setter(CreateConfiguredModelAlgorithmRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, TRAINING_CONTAINER_CONFIG_FIELD, INFERENCE_CONTAINER_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConfiguredModelAlgorithmRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String roleArn;
    private final ContainerConfig trainingContainerConfig;
    private final InferenceContainerConfig inferenceContainerConfig;
    private final Map<String, String> tags;
    private final String kmsKeyArn;

    private CreateConfiguredModelAlgorithmRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.trainingContainerConfig = builder.trainingContainerConfig;
        this.inferenceContainerConfig = builder.inferenceContainerConfig;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ContainerConfig trainingContainerConfig() {
        return this.trainingContainerConfig;
    }

    public final InferenceContainerConfig inferenceContainerConfig() {
        return this.inferenceContainerConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredModelAlgorithmRequest)) {
            return false;
        }
        CreateConfiguredModelAlgorithmRequest other = (CreateConfiguredModelAlgorithmRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.trainingContainerConfig(), other.trainingContainerConfig()) && Objects.equals(this.inferenceContainerConfig(), other.inferenceContainerConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredModelAlgorithmRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("TrainingContainerConfig", (Object)this.trainingContainerConfig()).add("InferenceContainerConfig", (Object)this.inferenceContainerConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "trainingContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingContainerConfig()));
            }
            case "inferenceContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceContainerConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("trainingContainerConfig", TRAINING_CONTAINER_CONFIG_FIELD);
        map.put("inferenceContainerConfig", INFERENCE_CONTAINER_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredModelAlgorithmRequest, T> g) {
        return obj -> g.apply((CreateConfiguredModelAlgorithmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String roleArn;
        private ContainerConfig trainingContainerConfig;
        private InferenceContainerConfig inferenceContainerConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredModelAlgorithmRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.trainingContainerConfig(model.trainingContainerConfig);
            this.inferenceContainerConfig(model.inferenceContainerConfig);
            this.tags(model.tags);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ContainerConfig.Builder getTrainingContainerConfig() {
            return this.trainingContainerConfig != null ? this.trainingContainerConfig.toBuilder() : null;
        }

        public final void setTrainingContainerConfig(ContainerConfig.BuilderImpl trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig != null ? trainingContainerConfig.build() : null;
        }

        @Override
        public final Builder trainingContainerConfig(ContainerConfig trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig;
            return this;
        }

        public final InferenceContainerConfig.Builder getInferenceContainerConfig() {
            return this.inferenceContainerConfig != null ? this.inferenceContainerConfig.toBuilder() : null;
        }

        public final void setInferenceContainerConfig(InferenceContainerConfig.BuilderImpl inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig != null ? inferenceContainerConfig.build() : null;
        }

        @Override
        public final Builder inferenceContainerConfig(InferenceContainerConfig inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredModelAlgorithmRequest build() {
            return new CreateConfiguredModelAlgorithmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredModelAlgorithmRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder trainingContainerConfig(ContainerConfig var1);

        default public Builder trainingContainerConfig(Consumer<ContainerConfig.Builder> trainingContainerConfig) {
            return this.trainingContainerConfig((ContainerConfig)((ContainerConfig.Builder)ContainerConfig.builder().applyMutation(trainingContainerConfig)).build());
        }

        public Builder inferenceContainerConfig(InferenceContainerConfig var1);

        default public Builder inferenceContainerConfig(Consumer<InferenceContainerConfig.Builder> inferenceContainerConfig) {
            return this.inferenceContainerConfig((InferenceContainerConfig)((InferenceContainerConfig.Builder)InferenceContainerConfig.builder().applyMutation(inferenceContainerConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

