/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetSummary;

public class ListTrainingDatasetsPublisher
implements SdkPublisher<ListTrainingDatasetsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListTrainingDatasetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainingDatasetsPublisher(CleanRoomsMlAsyncClient client, ListTrainingDatasetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainingDatasetsPublisher(CleanRoomsMlAsyncClient client, ListTrainingDatasetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainingDatasetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainingDatasetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrainingDatasetSummary> trainingDatasets() {
        Function<ListTrainingDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingDatasets() != null) {
                return response.trainingDatasets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrainingDatasetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrainingDatasetsResponseFetcher
    implements AsyncPageFetcher<ListTrainingDatasetsResponse> {
        private ListTrainingDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrainingDatasetsResponse> nextPage(ListTrainingDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingDatasetsPublisher.this.client.listTrainingDatasets(ListTrainingDatasetsPublisher.this.firstRequest);
            }
            return ListTrainingDatasetsPublisher.this.client.listTrainingDatasets((ListTrainingDatasetsRequest)((Object)ListTrainingDatasetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

