/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.ComputeConfiguration;
import software.amazon.awssdk.services.cleanroomsml.model.ProtectedQuerySQLParameters;
import software.amazon.awssdk.services.cleanroomsml.model.S3ConfigMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudienceGenerationJobDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudienceGenerationJobDataSource> {
    private static final SdkField<S3ConfigMap> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(AudienceGenerationJobDataSource.getter(AudienceGenerationJobDataSource::dataSource)).setter(AudienceGenerationJobDataSource.setter(Builder::dataSource)).constructor(S3ConfigMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(AudienceGenerationJobDataSource.getter(AudienceGenerationJobDataSource::roleArn)).setter(AudienceGenerationJobDataSource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqlParameters").getter(AudienceGenerationJobDataSource.getter(AudienceGenerationJobDataSource::sqlParameters)).setter(AudienceGenerationJobDataSource.setter(Builder::sqlParameters)).constructor(ProtectedQuerySQLParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()}).build();
    private static final SdkField<ComputeConfiguration> SQL_COMPUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqlComputeConfiguration").getter(AudienceGenerationJobDataSource.getter(AudienceGenerationJobDataSource::sqlComputeConfiguration)).setter(AudienceGenerationJobDataSource.setter(Builder::sqlComputeConfiguration)).constructor(ComputeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlComputeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROLE_ARN_FIELD, SQL_PARAMETERS_FIELD, SQL_COMPUTE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudienceGenerationJobDataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3ConfigMap dataSource;
    private final String roleArn;
    private final ProtectedQuerySQLParameters sqlParameters;
    private final ComputeConfiguration sqlComputeConfiguration;

    private AudienceGenerationJobDataSource(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
        this.sqlParameters = builder.sqlParameters;
        this.sqlComputeConfiguration = builder.sqlComputeConfiguration;
    }

    public final S3ConfigMap dataSource() {
        return this.dataSource;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ProtectedQuerySQLParameters sqlParameters() {
        return this.sqlParameters;
    }

    public final ComputeConfiguration sqlComputeConfiguration() {
        return this.sqlComputeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlComputeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceGenerationJobDataSource)) {
            return false;
        }
        AudienceGenerationJobDataSource other = (AudienceGenerationJobDataSource)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.sqlParameters(), other.sqlParameters()) && Objects.equals(this.sqlComputeConfiguration(), other.sqlComputeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AudienceGenerationJobDataSource").add("DataSource", (Object)this.dataSource()).add("RoleArn", (Object)this.roleArn()).add("SqlParameters", (Object)(this.sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("SqlComputeConfiguration", (Object)this.sqlComputeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "sqlParameters": {
                return Optional.ofNullable(clazz.cast(this.sqlParameters()));
            }
            case "sqlComputeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sqlComputeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("sqlParameters", SQL_PARAMETERS_FIELD);
        map.put("sqlComputeConfiguration", SQL_COMPUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceGenerationJobDataSource, T> g) {
        return obj -> g.apply((AudienceGenerationJobDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3ConfigMap dataSource;
        private String roleArn;
        private ProtectedQuerySQLParameters sqlParameters;
        private ComputeConfiguration sqlComputeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceGenerationJobDataSource model) {
            this.dataSource(model.dataSource);
            this.roleArn(model.roleArn);
            this.sqlParameters(model.sqlParameters);
            this.sqlComputeConfiguration(model.sqlComputeConfiguration);
        }

        public final S3ConfigMap.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(S3ConfigMap.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(S3ConfigMap dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return this.sqlParameters != null ? this.sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final ComputeConfiguration.Builder getSqlComputeConfiguration() {
            return this.sqlComputeConfiguration != null ? this.sqlComputeConfiguration.toBuilder() : null;
        }

        public final void setSqlComputeConfiguration(ComputeConfiguration.BuilderImpl sqlComputeConfiguration) {
            this.sqlComputeConfiguration = sqlComputeConfiguration != null ? sqlComputeConfiguration.build() : null;
        }

        @Override
        public final Builder sqlComputeConfiguration(ComputeConfiguration sqlComputeConfiguration) {
            this.sqlComputeConfiguration = sqlComputeConfiguration;
            return this;
        }

        public AudienceGenerationJobDataSource build() {
            return new AudienceGenerationJobDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudienceGenerationJobDataSource> {
        public Builder dataSource(S3ConfigMap var1);

        default public Builder dataSource(Consumer<S3ConfigMap.Builder> dataSource) {
            return this.dataSource((S3ConfigMap)((S3ConfigMap.Builder)S3ConfigMap.builder().applyMutation(dataSource)).build());
        }

        public Builder roleArn(String var1);

        public Builder sqlParameters(ProtectedQuerySQLParameters var1);

        default public Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return this.sqlParameters((ProtectedQuerySQLParameters)((ProtectedQuerySQLParameters.Builder)ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters)).build());
        }

        public Builder sqlComputeConfiguration(ComputeConfiguration var1);

        default public Builder sqlComputeConfiguration(Consumer<ComputeConfiguration.Builder> sqlComputeConfiguration) {
            return this.sqlComputeConfiguration((ComputeConfiguration)((ComputeConfiguration.Builder)ComputeConfiguration.builder().applyMutation(sqlComputeConfiguration)).build());
        }
    }
}

