/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationConfiguredModelAlgorithmAssociationsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListCollaborationConfiguredModelAlgorithmAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse.getter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse::nextToken)).setter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationConfiguredModelAlgorithmAssociationSummary>> COLLABORATION_CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationConfiguredModelAlgorithmAssociations").getter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse.getter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse::collaborationConfiguredModelAlgorithmAssociations)).setter(ListCollaborationConfiguredModelAlgorithmAssociationsResponse.setter(Builder::collaborationConfiguredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationConfiguredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationConfiguredModelAlgorithmAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollaborationConfiguredModelAlgorithmAssociationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CollaborationConfiguredModelAlgorithmAssociationSummary> collaborationConfiguredModelAlgorithmAssociations;

    private ListCollaborationConfiguredModelAlgorithmAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationConfiguredModelAlgorithmAssociations = builder.collaborationConfiguredModelAlgorithmAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationConfiguredModelAlgorithmAssociations() {
        return this.collaborationConfiguredModelAlgorithmAssociations != null && !(this.collaborationConfiguredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<CollaborationConfiguredModelAlgorithmAssociationSummary> collaborationConfiguredModelAlgorithmAssociations() {
        return this.collaborationConfiguredModelAlgorithmAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationConfiguredModelAlgorithmAssociations() ? this.collaborationConfiguredModelAlgorithmAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationConfiguredModelAlgorithmAssociationsResponse)) {
            return false;
        }
        ListCollaborationConfiguredModelAlgorithmAssociationsResponse other = (ListCollaborationConfiguredModelAlgorithmAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationConfiguredModelAlgorithmAssociations() == other.hasCollaborationConfiguredModelAlgorithmAssociations() && Objects.equals(this.collaborationConfiguredModelAlgorithmAssociations(), other.collaborationConfiguredModelAlgorithmAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationConfiguredModelAlgorithmAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationConfiguredModelAlgorithmAssociations", this.hasCollaborationConfiguredModelAlgorithmAssociations() ? this.collaborationConfiguredModelAlgorithmAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationConfiguredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.collaborationConfiguredModelAlgorithmAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("collaborationConfiguredModelAlgorithmAssociations", COLLABORATION_CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationConfiguredModelAlgorithmAssociationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationConfiguredModelAlgorithmAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationConfiguredModelAlgorithmAssociationSummary> collaborationConfiguredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationConfiguredModelAlgorithmAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationConfiguredModelAlgorithmAssociations(model.collaborationConfiguredModelAlgorithmAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationConfiguredModelAlgorithmAssociationSummary.Builder> getCollaborationConfiguredModelAlgorithmAssociations() {
            List<CollaborationConfiguredModelAlgorithmAssociationSummary.Builder> result = CollaborationConfiguredModelAlgorithmAssociationListCopier.copyToBuilder(this.collaborationConfiguredModelAlgorithmAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationConfiguredModelAlgorithmAssociations(Collection<CollaborationConfiguredModelAlgorithmAssociationSummary.BuilderImpl> collaborationConfiguredModelAlgorithmAssociations) {
            this.collaborationConfiguredModelAlgorithmAssociations = CollaborationConfiguredModelAlgorithmAssociationListCopier.copyFromBuilder(collaborationConfiguredModelAlgorithmAssociations);
        }

        @Override
        public final Builder collaborationConfiguredModelAlgorithmAssociations(Collection<CollaborationConfiguredModelAlgorithmAssociationSummary> collaborationConfiguredModelAlgorithmAssociations) {
            this.collaborationConfiguredModelAlgorithmAssociations = CollaborationConfiguredModelAlgorithmAssociationListCopier.copy(collaborationConfiguredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationConfiguredModelAlgorithmAssociations(CollaborationConfiguredModelAlgorithmAssociationSummary ... collaborationConfiguredModelAlgorithmAssociations) {
            this.collaborationConfiguredModelAlgorithmAssociations(Arrays.asList(collaborationConfiguredModelAlgorithmAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationConfiguredModelAlgorithmAssociations(Consumer<CollaborationConfiguredModelAlgorithmAssociationSummary.Builder> ... collaborationConfiguredModelAlgorithmAssociations) {
            this.collaborationConfiguredModelAlgorithmAssociations(Stream.of(collaborationConfiguredModelAlgorithmAssociations).map(c -> (CollaborationConfiguredModelAlgorithmAssociationSummary)((CollaborationConfiguredModelAlgorithmAssociationSummary.Builder)CollaborationConfiguredModelAlgorithmAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationConfiguredModelAlgorithmAssociationsResponse build() {
            return new ListCollaborationConfiguredModelAlgorithmAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationConfiguredModelAlgorithmAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationConfiguredModelAlgorithmAssociations(Collection<CollaborationConfiguredModelAlgorithmAssociationSummary> var1);

        public Builder collaborationConfiguredModelAlgorithmAssociations(CollaborationConfiguredModelAlgorithmAssociationSummary ... var1);

        public Builder collaborationConfiguredModelAlgorithmAssociations(Consumer<CollaborationConfiguredModelAlgorithmAssociationSummary.Builder> ... var1);
    }
}

