/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.LogsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsStatus;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceConfig;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.services.cleanroomsml.model.StoppingCondition;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationTrainedModelResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetCollaborationTrainedModelResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::membershipIdentifier)).setter(GetCollaborationTrainedModelResponse.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::collaborationIdentifier)).setter(GetCollaborationTrainedModelResponse.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::trainedModelArn)).setter(GetCollaborationTrainedModelResponse.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::name)).setter(GetCollaborationTrainedModelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::description)).setter(GetCollaborationTrainedModelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::statusAsString)).setter(GetCollaborationTrainedModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::statusDetails)).setter(GetCollaborationTrainedModelResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::configuredModelAlgorithmAssociationArn)).setter(GetCollaborationTrainedModelResponse.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfig").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::resourceConfig)).setter(GetCollaborationTrainedModelResponse.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stoppingCondition").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::stoppingCondition)).setter(GetCollaborationTrainedModelResponse.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()}).build();
    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatus").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::metricsStatusAsString)).setter(GetCollaborationTrainedModelResponse.setter(Builder::metricsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()}).build();
    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricsStatusDetails").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::metricsStatusDetails)).setter(GetCollaborationTrainedModelResponse.setter(Builder::metricsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build()}).build();
    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatus").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::logsStatusAsString)).setter(GetCollaborationTrainedModelResponse.setter(Builder::logsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()}).build();
    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logsStatusDetails").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::logsStatusDetails)).setter(GetCollaborationTrainedModelResponse.setter(Builder::logsStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()}).build();
    private static final SdkField<String> TRAINING_CONTAINER_IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingContainerImageDigest").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::trainingContainerImageDigest)).setter(GetCollaborationTrainedModelResponse.setter(Builder::trainingContainerImageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingContainerImageDigest").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::createTime)).setter(GetCollaborationTrainedModelResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::updateTime)).setter(GetCollaborationTrainedModelResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(GetCollaborationTrainedModelResponse.getter(GetCollaborationTrainedModelResponse::creatorAccountId)).setter(GetCollaborationTrainedModelResponse.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, TRAINED_MODEL_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD, LOGS_STATUS_FIELD, LOGS_STATUS_DETAILS_FIELD, TRAINING_CONTAINER_IMAGE_DIGEST_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, CREATOR_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCollaborationTrainedModelResponse.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final String trainedModelArn;
    private final String name;
    private final String description;
    private final String status;
    private final StatusDetails statusDetails;
    private final String configuredModelAlgorithmAssociationArn;
    private final ResourceConfig resourceConfig;
    private final StoppingCondition stoppingCondition;
    private final String metricsStatus;
    private final String metricsStatusDetails;
    private final String logsStatus;
    private final String logsStatusDetails;
    private final String trainingContainerImageDigest;
    private final Instant createTime;
    private final Instant updateTime;
    private final String creatorAccountId;

    private GetCollaborationTrainedModelResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.trainingContainerImageDigest = builder.trainingContainerImageDigest;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.creatorAccountId = builder.creatorAccountId;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TrainedModelStatus status() {
        return TrainedModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(this.metricsStatus);
    }

    public final String metricsStatusAsString() {
        return this.metricsStatus;
    }

    public final String metricsStatusDetails() {
        return this.metricsStatusDetails;
    }

    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(this.logsStatus);
    }

    public final String logsStatusAsString() {
        return this.logsStatus;
    }

    public final String logsStatusDetails() {
        return this.logsStatusDetails;
    }

    public final String trainingContainerImageDigest() {
        return this.trainingContainerImageDigest;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingContainerImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationTrainedModelResponse)) {
            return false;
        }
        GetCollaborationTrainedModelResponse other = (GetCollaborationTrainedModelResponse)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.metricsStatusAsString(), other.metricsStatusAsString()) && Objects.equals(this.metricsStatusDetails(), other.metricsStatusDetails()) && Objects.equals(this.logsStatusAsString(), other.logsStatusAsString()) && Objects.equals(this.logsStatusDetails(), other.logsStatusDetails()) && Objects.equals(this.trainingContainerImageDigest(), other.trainingContainerImageDigest()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationTrainedModelResponse").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("ResourceConfig", (Object)this.resourceConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("MetricsStatus", (Object)this.metricsStatusAsString()).add("MetricsStatusDetails", (Object)this.metricsStatusDetails()).add("LogsStatus", (Object)this.logsStatusAsString()).add("LogsStatusDetails", (Object)this.logsStatusDetails()).add("TrainingContainerImageDigest", (Object)this.trainingContainerImageDigest()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("CreatorAccountId", (Object)this.creatorAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "resourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "stoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "metricsStatus": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusAsString()));
            }
            case "metricsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.metricsStatusDetails()));
            }
            case "logsStatus": {
                return Optional.ofNullable(clazz.cast(this.logsStatusAsString()));
            }
            case "logsStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.logsStatusDetails()));
            }
            case "trainingContainerImageDigest": {
                return Optional.ofNullable(clazz.cast(this.trainingContainerImageDigest()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("stoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("metricsStatus", METRICS_STATUS_FIELD);
        map.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
        map.put("logsStatus", LOGS_STATUS_FIELD);
        map.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
        map.put("trainingContainerImageDigest", TRAINING_CONTAINER_IMAGE_DIGEST_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationTrainedModelResponse, T> g) {
        return obj -> g.apply((GetCollaborationTrainedModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private String trainedModelArn;
        private String name;
        private String description;
        private String status;
        private StatusDetails statusDetails;
        private String configuredModelAlgorithmAssociationArn;
        private ResourceConfig resourceConfig;
        private StoppingCondition stoppingCondition;
        private String metricsStatus;
        private String metricsStatusDetails;
        private String logsStatus;
        private String logsStatusDetails;
        private String trainingContainerImageDigest;
        private Instant createTime;
        private Instant updateTime;
        private String creatorAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationTrainedModelResponse model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.trainedModelArn(model.trainedModelArn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.resourceConfig(model.resourceConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.metricsStatus(model.metricsStatus);
            this.metricsStatusDetails(model.metricsStatusDetails);
            this.logsStatus(model.logsStatus);
            this.logsStatusDetails(model.logsStatusDetails);
            this.trainingContainerImageDigest(model.trainingContainerImageDigest);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.creatorAccountId(model.creatorAccountId);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final String getMetricsStatus() {
            return this.metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return this.metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return this.logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return this.logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final String getTrainingContainerImageDigest() {
            return this.trainingContainerImageDigest;
        }

        public final void setTrainingContainerImageDigest(String trainingContainerImageDigest) {
            this.trainingContainerImageDigest = trainingContainerImageDigest;
        }

        @Override
        public final Builder trainingContainerImageDigest(String trainingContainerImageDigest) {
            this.trainingContainerImageDigest = trainingContainerImageDigest;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        @Override
        public GetCollaborationTrainedModelResponse build() {
            return new GetCollaborationTrainedModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationTrainedModelResponse> {
        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder trainedModelArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(TrainedModelStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder metricsStatus(String var1);

        public Builder metricsStatus(MetricsStatus var1);

        public Builder metricsStatusDetails(String var1);

        public Builder logsStatus(String var1);

        public Builder logsStatus(LogsStatus var1);

        public Builder logsStatusDetails(String var1);

        public Builder trainingContainerImageDigest(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder creatorAccountId(String var1);
    }
}

