/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.EnvironmentCopier;
import software.amazon.awssdk.services.cleanroomsml.model.HyperParametersCopier;
import software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel;
import software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannelsCopier;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceConfig;
import software.amazon.awssdk.services.cleanroomsml.model.StoppingCondition;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrainedModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, CreateTrainedModelRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::membershipIdentifier)).setter(CreateTrainedModelRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::name)).setter(CreateTrainedModelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredModelAlgorithmAssociationArn").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::configuredModelAlgorithmAssociationArn)).setter(CreateTrainedModelRequest.setter(Builder::configuredModelAlgorithmAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociationArn").build()}).build();
    private static final SdkField<Map<String, String>> HYPERPARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperparameters").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::hyperparameters)).setter(CreateTrainedModelRequest.setter(Builder::hyperparameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperparameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environment").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::environment)).setter(CreateTrainedModelRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfig").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::resourceConfig)).setter(CreateTrainedModelRequest.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stoppingCondition").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::stoppingCondition)).setter(CreateTrainedModelRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()}).build();
    private static final SdkField<List<ModelTrainingDataChannel>> DATA_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataChannels").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::dataChannels)).setter(CreateTrainedModelRequest.setter(Builder::dataChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelTrainingDataChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::description)).setter(CreateTrainedModelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::kmsKeyArn)).setter(CreateTrainedModelRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateTrainedModelRequest.getter(CreateTrainedModelRequest::tags)).setter(CreateTrainedModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, HYPERPARAMETERS_FIELD, ENVIRONMENT_FIELD, RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD, DATA_CHANNELS_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrainedModelRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String name;
    private final String configuredModelAlgorithmAssociationArn;
    private final Map<String, String> hyperparameters;
    private final Map<String, String> environment;
    private final ResourceConfig resourceConfig;
    private final StoppingCondition stoppingCondition;
    private final List<ModelTrainingDataChannel> dataChannels;
    private final String description;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private CreateTrainedModelRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.hyperparameters = builder.hyperparameters;
        this.environment = builder.environment;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.dataChannels = builder.dataChannels;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String configuredModelAlgorithmAssociationArn() {
        return this.configuredModelAlgorithmAssociationArn;
    }

    public final boolean hasHyperparameters() {
        return this.hyperparameters != null && !(this.hyperparameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperparameters() {
        return this.hyperparameters;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasDataChannels() {
        return this.dataChannels != null && !(this.dataChannels instanceof SdkAutoConstructList);
    }

    public final List<ModelTrainingDataChannel> dataChannels() {
        return this.dataChannels;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperparameters() ? this.hyperparameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataChannels() ? this.dataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainedModelRequest)) {
            return false;
        }
        CreateTrainedModelRequest other = (CreateTrainedModelRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn()) && this.hasHyperparameters() == other.hasHyperparameters() && Objects.equals(this.hyperparameters(), other.hyperparameters()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasDataChannels() == other.hasDataChannels() && Objects.equals(this.dataChannels(), other.dataChannels()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrainedModelRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Name", (Object)this.name()).add("ConfiguredModelAlgorithmAssociationArn", (Object)this.configuredModelAlgorithmAssociationArn()).add("Hyperparameters", this.hasHyperparameters() ? this.hyperparameters() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("ResourceConfig", (Object)this.resourceConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("DataChannels", this.hasDataChannels() ? this.dataChannels() : null).add("Description", (Object)this.description()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuredModelAlgorithmAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociationArn()));
            }
            case "hyperparameters": {
                return Optional.ofNullable(clazz.cast(this.hyperparameters()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "resourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "stoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "dataChannels": {
                return Optional.ofNullable(clazz.cast(this.dataChannels()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("hyperparameters", HYPERPARAMETERS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("stoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("dataChannels", DATA_CHANNELS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainedModelRequest, T> g) {
        return obj -> g.apply((CreateTrainedModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String name;
        private String configuredModelAlgorithmAssociationArn;
        private Map<String, String> hyperparameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private ResourceConfig resourceConfig;
        private StoppingCondition stoppingCondition;
        private List<ModelTrainingDataChannel> dataChannels = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainedModelRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.name(model.name);
            this.configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            this.hyperparameters(model.hyperparameters);
            this.environment(model.environment);
            this.resourceConfig(model.resourceConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.dataChannels(model.dataChannels);
            this.description(model.description);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return this.configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final Map<String, String> getHyperparameters() {
            if (this.hyperparameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperparameters;
        }

        public final void setHyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
        }

        @Override
        public final Builder hyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<ModelTrainingDataChannel.Builder> getDataChannels() {
            List<ModelTrainingDataChannel.Builder> result = ModelTrainingDataChannelsCopier.copyToBuilder(this.dataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataChannels(Collection<ModelTrainingDataChannel.BuilderImpl> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copyFromBuilder(dataChannels);
        }

        @Override
        public final Builder dataChannels(Collection<ModelTrainingDataChannel> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copy(dataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(ModelTrainingDataChannel ... dataChannels) {
            this.dataChannels(Arrays.asList(dataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder> ... dataChannels) {
            this.dataChannels(Stream.of(dataChannels).map(c -> (ModelTrainingDataChannel)((ModelTrainingDataChannel.Builder)ModelTrainingDataChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainedModelRequest build() {
            return new CreateTrainedModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrainedModelRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder name(String var1);

        public Builder configuredModelAlgorithmAssociationArn(String var1);

        public Builder hyperparameters(Map<String, String> var1);

        public Builder environment(Map<String, String> var1);

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder dataChannels(Collection<ModelTrainingDataChannel> var1);

        public Builder dataChannels(ModelTrainingDataChannel ... var1);

        public Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder> ... var1);

        public Builder description(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

