/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportsConfigurationPolicy;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelInferenceJobsConfigurationPolicy;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelsConfigurationPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivacyConfigurationPolicies
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivacyConfigurationPolicies> {
    private static final SdkField<TrainedModelsConfigurationPolicy> TRAINED_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainedModels").getter(PrivacyConfigurationPolicies.getter(PrivacyConfigurationPolicies::trainedModels)).setter(PrivacyConfigurationPolicies.setter(Builder::trainedModels)).constructor(TrainedModelsConfigurationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModels").build()}).build();
    private static final SdkField<TrainedModelExportsConfigurationPolicy> TRAINED_MODEL_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainedModelExports").getter(PrivacyConfigurationPolicies.getter(PrivacyConfigurationPolicies::trainedModelExports)).setter(PrivacyConfigurationPolicies.setter(Builder::trainedModelExports)).constructor(TrainedModelExportsConfigurationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelExports").build()}).build();
    private static final SdkField<TrainedModelInferenceJobsConfigurationPolicy> TRAINED_MODEL_INFERENCE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainedModelInferenceJobs").getter(PrivacyConfigurationPolicies.getter(PrivacyConfigurationPolicies::trainedModelInferenceJobs)).setter(PrivacyConfigurationPolicies.setter(Builder::trainedModelInferenceJobs)).constructor(TrainedModelInferenceJobsConfigurationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODELS_FIELD, TRAINED_MODEL_EXPORTS_FIELD, TRAINED_MODEL_INFERENCE_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("trainedModels", TRAINED_MODELS_FIELD);
            this.put("trainedModelExports", TRAINED_MODEL_EXPORTS_FIELD);
            this.put("trainedModelInferenceJobs", TRAINED_MODEL_INFERENCE_JOBS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TrainedModelsConfigurationPolicy trainedModels;
    private final TrainedModelExportsConfigurationPolicy trainedModelExports;
    private final TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs;

    private PrivacyConfigurationPolicies(BuilderImpl builder) {
        this.trainedModels = builder.trainedModels;
        this.trainedModelExports = builder.trainedModelExports;
        this.trainedModelInferenceJobs = builder.trainedModelInferenceJobs;
    }

    public final TrainedModelsConfigurationPolicy trainedModels() {
        return this.trainedModels;
    }

    public final TrainedModelExportsConfigurationPolicy trainedModelExports() {
        return this.trainedModelExports;
    }

    public final TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs() {
        return this.trainedModelInferenceJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelExports());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelInferenceJobs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyConfigurationPolicies)) {
            return false;
        }
        PrivacyConfigurationPolicies other = (PrivacyConfigurationPolicies)obj;
        return Objects.equals(this.trainedModels(), other.trainedModels()) && Objects.equals(this.trainedModelExports(), other.trainedModelExports()) && Objects.equals(this.trainedModelInferenceJobs(), other.trainedModelInferenceJobs());
    }

    public final String toString() {
        return ToString.builder((String)"PrivacyConfigurationPolicies").add("TrainedModels", (Object)this.trainedModels()).add("TrainedModelExports", (Object)this.trainedModelExports()).add("TrainedModelInferenceJobs", (Object)this.trainedModelInferenceJobs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trainedModels": {
                return Optional.ofNullable(clazz.cast(this.trainedModels()));
            }
            case "trainedModelExports": {
                return Optional.ofNullable(clazz.cast(this.trainedModelExports()));
            }
            case "trainedModelInferenceJobs": {
                return Optional.ofNullable(clazz.cast(this.trainedModelInferenceJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrivacyConfigurationPolicies, T> g) {
        return obj -> g.apply((PrivacyConfigurationPolicies)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TrainedModelsConfigurationPolicy trainedModels;
        private TrainedModelExportsConfigurationPolicy trainedModelExports;
        private TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyConfigurationPolicies model) {
            this.trainedModels(model.trainedModels);
            this.trainedModelExports(model.trainedModelExports);
            this.trainedModelInferenceJobs(model.trainedModelInferenceJobs);
        }

        public final TrainedModelsConfigurationPolicy.Builder getTrainedModels() {
            return this.trainedModels != null ? this.trainedModels.toBuilder() : null;
        }

        public final void setTrainedModels(TrainedModelsConfigurationPolicy.BuilderImpl trainedModels) {
            this.trainedModels = trainedModels != null ? trainedModels.build() : null;
        }

        @Override
        public final Builder trainedModels(TrainedModelsConfigurationPolicy trainedModels) {
            this.trainedModels = trainedModels;
            return this;
        }

        public final TrainedModelExportsConfigurationPolicy.Builder getTrainedModelExports() {
            return this.trainedModelExports != null ? this.trainedModelExports.toBuilder() : null;
        }

        public final void setTrainedModelExports(TrainedModelExportsConfigurationPolicy.BuilderImpl trainedModelExports) {
            this.trainedModelExports = trainedModelExports != null ? trainedModelExports.build() : null;
        }

        @Override
        public final Builder trainedModelExports(TrainedModelExportsConfigurationPolicy trainedModelExports) {
            this.trainedModelExports = trainedModelExports;
            return this;
        }

        public final TrainedModelInferenceJobsConfigurationPolicy.Builder getTrainedModelInferenceJobs() {
            return this.trainedModelInferenceJobs != null ? this.trainedModelInferenceJobs.toBuilder() : null;
        }

        public final void setTrainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy.BuilderImpl trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = trainedModelInferenceJobs != null ? trainedModelInferenceJobs.build() : null;
        }

        @Override
        public final Builder trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy trainedModelInferenceJobs) {
            this.trainedModelInferenceJobs = trainedModelInferenceJobs;
            return this;
        }

        public PrivacyConfigurationPolicies build() {
            return new PrivacyConfigurationPolicies(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivacyConfigurationPolicies> {
        public Builder trainedModels(TrainedModelsConfigurationPolicy var1);

        default public Builder trainedModels(Consumer<TrainedModelsConfigurationPolicy.Builder> trainedModels) {
            return this.trainedModels((TrainedModelsConfigurationPolicy)((TrainedModelsConfigurationPolicy.Builder)TrainedModelsConfigurationPolicy.builder().applyMutation(trainedModels)).build());
        }

        public Builder trainedModelExports(TrainedModelExportsConfigurationPolicy var1);

        default public Builder trainedModelExports(Consumer<TrainedModelExportsConfigurationPolicy.Builder> trainedModelExports) {
            return this.trainedModelExports((TrainedModelExportsConfigurationPolicy)((TrainedModelExportsConfigurationPolicy.Builder)TrainedModelExportsConfigurationPolicy.builder().applyMutation(trainedModelExports)).build());
        }

        public Builder trainedModelInferenceJobs(TrainedModelInferenceJobsConfigurationPolicy var1);

        default public Builder trainedModelInferenceJobs(Consumer<TrainedModelInferenceJobsConfigurationPolicy.Builder> trainedModelInferenceJobs) {
            return this.trainedModelInferenceJobs((TrainedModelInferenceJobsConfigurationPolicy)((TrainedModelInferenceJobsConfigurationPolicy.Builder)TrainedModelInferenceJobsConfigurationPolicy.builder().applyMutation(trainedModelInferenceJobs)).build());
        }
    }
}

