/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.DatasetInputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.DatasetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dataset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dataset> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Dataset.getter(Dataset::typeAsString)).setter(Dataset.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<DatasetInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfig").getter(Dataset.getter(Dataset::inputConfig)).setter(Dataset.setter(Builder::inputConfig)).constructor(DatasetInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, INPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("inputConfig", INPUT_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final DatasetInputConfig inputConfig;

    private Dataset(BuilderImpl builder) {
        this.type = builder.type;
        this.inputConfig = builder.inputConfig;
    }

    public final DatasetType type() {
        return DatasetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DatasetInputConfig inputConfig() {
        return this.inputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.inputConfig(), other.inputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Dataset").add("Type", (Object)this.typeAsString()).add("InputConfig", (Object)this.inputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "inputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Dataset, T> g) {
        return obj -> g.apply((Dataset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private DatasetInputConfig inputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            this.type(model.type);
            this.inputConfig(model.inputConfig);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DatasetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DatasetInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(DatasetInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(DatasetInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public Dataset build() {
            return new Dataset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dataset> {
        public Builder type(String var1);

        public Builder type(DatasetType var1);

        public Builder inputConfig(DatasetInputConfig var1);

        default public Builder inputConfig(Consumer<DatasetInputConfig.Builder> inputConfig) {
            return this.inputConfig((DatasetInputConfig)((DatasetInputConfig.Builder)DatasetInputConfig.builder().applyMutation(inputConfig)).build());
        }
    }
}

