/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceReceiverMember;
import software.amazon.awssdk.services.cleanroomsml.model.InferenceReceiverMembersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceOutputConfiguration> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(InferenceOutputConfiguration.getter(InferenceOutputConfiguration::accept)).setter(InferenceOutputConfiguration.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accept").build()}).build();
    private static final SdkField<List<InferenceReceiverMember>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("members").getter(InferenceOutputConfiguration.getter(InferenceOutputConfiguration::members)).setter(InferenceOutputConfiguration.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceReceiverMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, MEMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accept", ACCEPT_FIELD);
            this.put("members", MEMBERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accept;
    private final List<InferenceReceiverMember> members;

    private InferenceOutputConfiguration(BuilderImpl builder) {
        this.accept = builder.accept;
        this.members = builder.members;
    }

    public final String accept() {
        return this.accept;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<InferenceReceiverMember> members() {
        return this.members;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceOutputConfiguration)) {
            return false;
        }
        InferenceOutputConfiguration other = (InferenceOutputConfiguration)obj;
        return Objects.equals(this.accept(), other.accept()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceOutputConfiguration").add("Accept", (Object)this.accept()).add("Members", this.hasMembers() ? this.members() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceOutputConfiguration, T> g) {
        return obj -> g.apply((InferenceOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accept;
        private List<InferenceReceiverMember> members = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceOutputConfiguration model) {
            this.accept(model.accept);
            this.members(model.members);
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final List<InferenceReceiverMember.Builder> getMembers() {
            List<InferenceReceiverMember.Builder> result = InferenceReceiverMembersCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<InferenceReceiverMember.BuilderImpl> members) {
            this.members = InferenceReceiverMembersCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<InferenceReceiverMember> members) {
            this.members = InferenceReceiverMembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(InferenceReceiverMember ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<InferenceReceiverMember.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (InferenceReceiverMember)((InferenceReceiverMember.Builder)InferenceReceiverMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InferenceOutputConfiguration build() {
            return new InferenceOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceOutputConfiguration> {
        public Builder accept(String var1);

        public Builder members(Collection<InferenceReceiverMember> var1);

        public Builder members(InferenceReceiverMember ... var1);

        public Builder members(Consumer<InferenceReceiverMember.Builder> ... var1);
    }
}

