/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobDataSource;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAudienceGenerationJobRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, StartAudienceGenerationJobRequest> {
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::collaborationId)).setter(StartAudienceGenerationJobRequest.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::configuredAudienceModelArn)).setter(StartAudienceGenerationJobRequest.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::description)).setter(StartAudienceGenerationJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SEED_IN_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeSeedInOutput").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::includeSeedInOutput)).setter(StartAudienceGenerationJobRequest.setter(Builder::includeSeedInOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSeedInOutput").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::name)).setter(StartAudienceGenerationJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<AudienceGenerationJobDataSource> SEED_AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("seedAudience").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::seedAudience)).setter(StartAudienceGenerationJobRequest.setter(Builder::seedAudience)).constructor(AudienceGenerationJobDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedAudience").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartAudienceGenerationJobRequest.getter(StartAudienceGenerationJobRequest::tags)).setter(StartAudienceGenerationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ID_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, DESCRIPTION_FIELD, INCLUDE_SEED_IN_OUTPUT_FIELD, NAME_FIELD, SEED_AUDIENCE_FIELD, TAGS_FIELD));
    private final String collaborationId;
    private final String configuredAudienceModelArn;
    private final String description;
    private final Boolean includeSeedInOutput;
    private final String name;
    private final AudienceGenerationJobDataSource seedAudience;
    private final Map<String, String> tags;

    private StartAudienceGenerationJobRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationId = builder.collaborationId;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.description = builder.description;
        this.includeSeedInOutput = builder.includeSeedInOutput;
        this.name = builder.name;
        this.seedAudience = builder.seedAudience;
        this.tags = builder.tags;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean includeSeedInOutput() {
        return this.includeSeedInOutput;
    }

    public final String name() {
        return this.name;
    }

    public final AudienceGenerationJobDataSource seedAudience() {
        return this.seedAudience;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSeedInOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.seedAudience());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAudienceGenerationJobRequest)) {
            return false;
        }
        StartAudienceGenerationJobRequest other = (StartAudienceGenerationJobRequest)((Object)obj);
        return Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.includeSeedInOutput(), other.includeSeedInOutput()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.seedAudience(), other.seedAudience()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartAudienceGenerationJobRequest").add("CollaborationId", (Object)this.collaborationId()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("Description", (Object)this.description()).add("IncludeSeedInOutput", (Object)this.includeSeedInOutput()).add("Name", (Object)this.name()).add("SeedAudience", (Object)this.seedAudience()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "includeSeedInOutput": {
                return Optional.ofNullable(clazz.cast(this.includeSeedInOutput()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "seedAudience": {
                return Optional.ofNullable(clazz.cast(this.seedAudience()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAudienceGenerationJobRequest, T> g) {
        return obj -> g.apply((StartAudienceGenerationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String collaborationId;
        private String configuredAudienceModelArn;
        private String description;
        private Boolean includeSeedInOutput;
        private String name;
        private AudienceGenerationJobDataSource seedAudience;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAudienceGenerationJobRequest model) {
            super(model);
            this.collaborationId(model.collaborationId);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.description(model.description);
            this.includeSeedInOutput(model.includeSeedInOutput);
            this.name(model.name);
            this.seedAudience(model.seedAudience);
            this.tags(model.tags);
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIncludeSeedInOutput() {
            return this.includeSeedInOutput;
        }

        public final void setIncludeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
        }

        @Override
        public final Builder includeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AudienceGenerationJobDataSource.Builder getSeedAudience() {
            return this.seedAudience != null ? this.seedAudience.toBuilder() : null;
        }

        public final void setSeedAudience(AudienceGenerationJobDataSource.BuilderImpl seedAudience) {
            this.seedAudience = seedAudience != null ? seedAudience.build() : null;
        }

        @Override
        public final Builder seedAudience(AudienceGenerationJobDataSource seedAudience) {
            this.seedAudience = seedAudience;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAudienceGenerationJobRequest build() {
            return new StartAudienceGenerationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAudienceGenerationJobRequest> {
        public Builder collaborationId(String var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder description(String var1);

        public Builder includeSeedInOutput(Boolean var1);

        public Builder name(String var1);

        public Builder seedAudience(AudienceGenerationJobDataSource var1);

        default public Builder seedAudience(Consumer<AudienceGenerationJobDataSource.Builder> seedAudience) {
            return this.seedAudience((AudienceGenerationJobDataSource)((AudienceGenerationJobDataSource.Builder)AudienceGenerationJobDataSource.builder().applyMutation(seedAudience)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

