/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredAudienceModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredAudienceModelSummary> {
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::audienceModelArn)).setter(ConfiguredAudienceModelSummary.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::configuredAudienceModelArn)).setter(ConfiguredAudienceModelSummary.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::createTime)).setter(ConfiguredAudienceModelSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::description)).setter(ConfiguredAudienceModelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::name)).setter(ConfiguredAudienceModelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::outputConfig)).setter(ConfiguredAudienceModelSummary.setter(Builder::outputConfig)).constructor(ConfiguredAudienceModelOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::statusAsString)).setter(ConfiguredAudienceModelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredAudienceModelSummary.getter(ConfiguredAudienceModelSummary::updateTime)).setter(ConfiguredAudienceModelSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CREATE_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, OUTPUT_CONFIG_FIELD, STATUS_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audienceModelArn;
    private final String configuredAudienceModelArn;
    private final Instant createTime;
    private final String description;
    private final String name;
    private final ConfiguredAudienceModelOutputConfig outputConfig;
    private final String status;
    private final Instant updateTime;

    private ConfiguredAudienceModelSummary(BuilderImpl builder) {
        this.audienceModelArn = builder.audienceModelArn;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.name = builder.name;
        this.outputConfig = builder.outputConfig;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final ConfiguredAudienceModelStatus status() {
        return ConfiguredAudienceModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredAudienceModelSummary)) {
            return false;
        }
        ConfiguredAudienceModelSummary other = (ConfiguredAudienceModelSummary)obj;
        return Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredAudienceModelSummary").add("AudienceModelArn", (Object)this.audienceModelArn()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("CreateTime", (Object)this.createTime()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("OutputConfig", (Object)this.outputConfig()).add("Status", (Object)this.statusAsString()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredAudienceModelSummary, T> g) {
        return obj -> g.apply((ConfiguredAudienceModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audienceModelArn;
        private String configuredAudienceModelArn;
        private Instant createTime;
        private String description;
        private String name;
        private ConfiguredAudienceModelOutputConfig outputConfig;
        private String status;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredAudienceModelSummary model) {
            this.audienceModelArn(model.audienceModelArn);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.createTime(model.createTime);
            this.description(model.description);
            this.name(model.name);
            this.outputConfig(model.outputConfig);
            this.status(model.status);
            this.updateTime(model.updateTime);
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfiguredAudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ConfiguredAudienceModelSummary build() {
            return new ConfiguredAudienceModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredAudienceModelSummary> {
        public Builder audienceModelArn(String var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder createTime(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder outputConfig(ConfiguredAudienceModelOutputConfig var1);

        default public Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ConfiguredAudienceModelOutputConfig)((ConfiguredAudienceModelOutputConfig.Builder)ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(ConfiguredAudienceModelStatus var1);

        public Builder updateTime(Instant var1);
    }
}

