/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;

public class ListAudienceGenerationJobsPublisher
implements SdkPublisher<ListAudienceGenerationJobsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListAudienceGenerationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAudienceGenerationJobsPublisher(CleanRoomsMlAsyncClient client, ListAudienceGenerationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAudienceGenerationJobsPublisher(CleanRoomsMlAsyncClient client, ListAudienceGenerationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAudienceGenerationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAudienceGenerationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AudienceGenerationJobSummary> audienceGenerationJobs() {
        Function<ListAudienceGenerationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceGenerationJobs() != null) {
                return response.audienceGenerationJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAudienceGenerationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAudienceGenerationJobsResponseFetcher
    implements AsyncPageFetcher<ListAudienceGenerationJobsResponse> {
        private ListAudienceGenerationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceGenerationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAudienceGenerationJobsResponse> nextPage(ListAudienceGenerationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceGenerationJobsPublisher.this.client.listAudienceGenerationJobs(ListAudienceGenerationJobsPublisher.this.firstRequest);
            }
            return ListAudienceGenerationJobsPublisher.this.client.listAudienceGenerationJobs((ListAudienceGenerationJobsRequest)((Object)ListAudienceGenerationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

