/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedJobsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedJobsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary;

public class ListProtectedJobsIterable
implements SdkIterable<ListProtectedJobsResponse> {
    private final CleanRoomsClient client;
    private final ListProtectedJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectedJobsIterable(CleanRoomsClient client, ListProtectedJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtectedJobsResponseFetcher();
    }

    public Iterator<ListProtectedJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtectedJobSummary> protectedJobs() {
        Function<ListProtectedJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protectedJobs() != null) {
                return response.protectedJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtectedJobsResponseFetcher
    implements SyncPageFetcher<ListProtectedJobsResponse> {
        private ListProtectedJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectedJobsResponse nextPage(ListProtectedJobsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedJobsIterable.this.client.listProtectedJobs(ListProtectedJobsIterable.this.firstRequest);
            }
            return ListProtectedJobsIterable.this.client.listProtectedJobs((ListProtectedJobsRequest)((Object)ListProtectedJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

