/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobMemberOutputConfigurationOutput;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobS3OutputConfigurationOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedJobOutputConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedJobOutputConfigurationOutput> {
    private static final SdkField<ProtectedJobS3OutputConfigurationOutput> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(ProtectedJobOutputConfigurationOutput.getter(ProtectedJobOutputConfigurationOutput::s3)).setter(ProtectedJobOutputConfigurationOutput.setter(Builder::s3)).constructor(ProtectedJobS3OutputConfigurationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<ProtectedJobMemberOutputConfigurationOutput> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("member").getter(ProtectedJobOutputConfigurationOutput.getter(ProtectedJobOutputConfigurationOutput::member)).setter(ProtectedJobOutputConfigurationOutput.setter(Builder::member)).constructor(ProtectedJobMemberOutputConfigurationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedJobOutputConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProtectedJobS3OutputConfigurationOutput s3;
    private final ProtectedJobMemberOutputConfigurationOutput member;
    private final Type type;

    private ProtectedJobOutputConfigurationOutput(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.member = builder.member;
        this.type = builder.type;
    }

    public final ProtectedJobS3OutputConfigurationOutput s3() {
        return this.s3;
    }

    public final ProtectedJobMemberOutputConfigurationOutput member() {
        return this.member;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobOutputConfigurationOutput)) {
            return false;
        }
        ProtectedJobOutputConfigurationOutput other = (ProtectedJobOutputConfigurationOutput)obj;
        return Objects.equals(this.s3(), other.s3()) && Objects.equals(this.member(), other.member());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedJobOutputConfigurationOutput").add("S3", (Object)this.s3()).add("Member", (Object)this.member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
        }
        return Optional.empty();
    }

    public static ProtectedJobOutputConfigurationOutput fromS3(ProtectedJobS3OutputConfigurationOutput s3) {
        return (ProtectedJobOutputConfigurationOutput)ProtectedJobOutputConfigurationOutput.builder().s3(s3).build();
    }

    public static ProtectedJobOutputConfigurationOutput fromS3(Consumer<ProtectedJobS3OutputConfigurationOutput.Builder> s3) {
        ProtectedJobS3OutputConfigurationOutput.Builder builder = ProtectedJobS3OutputConfigurationOutput.builder();
        s3.accept(builder);
        return ProtectedJobOutputConfigurationOutput.fromS3((ProtectedJobS3OutputConfigurationOutput)builder.build());
    }

    public static ProtectedJobOutputConfigurationOutput fromMember(ProtectedJobMemberOutputConfigurationOutput member) {
        return (ProtectedJobOutputConfigurationOutput)ProtectedJobOutputConfigurationOutput.builder().member(member).build();
    }

    public static ProtectedJobOutputConfigurationOutput fromMember(Consumer<ProtectedJobMemberOutputConfigurationOutput.Builder> member) {
        ProtectedJobMemberOutputConfigurationOutput.Builder builder = ProtectedJobMemberOutputConfigurationOutput.builder();
        member.accept(builder);
        return ProtectedJobOutputConfigurationOutput.fromMember((ProtectedJobMemberOutputConfigurationOutput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3", S3_FIELD);
        map.put("member", MEMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobOutputConfigurationOutput, T> g) {
        return obj -> g.apply((ProtectedJobOutputConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        MEMBER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProtectedJobS3OutputConfigurationOutput s3;
        private ProtectedJobMemberOutputConfigurationOutput member;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobOutputConfigurationOutput model) {
            this.s3(model.s3);
            this.member(model.member);
        }

        public final ProtectedJobS3OutputConfigurationOutput.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(ProtectedJobS3OutputConfigurationOutput.BuilderImpl s3) {
            ProtectedJobS3OutputConfigurationOutput oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(ProtectedJobS3OutputConfigurationOutput s3) {
            ProtectedJobS3OutputConfigurationOutput oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final ProtectedJobMemberOutputConfigurationOutput.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(ProtectedJobMemberOutputConfigurationOutput.BuilderImpl member) {
            ProtectedJobMemberOutputConfigurationOutput oldValue = this.member;
            this.member = member != null ? member.build() : null;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
        }

        @Override
        public final Builder member(ProtectedJobMemberOutputConfigurationOutput member) {
            ProtectedJobMemberOutputConfigurationOutput oldValue = this.member;
            this.member = member;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
            return this;
        }

        public ProtectedJobOutputConfigurationOutput build() {
            return new ProtectedJobOutputConfigurationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedJobOutputConfigurationOutput> {
        public Builder s3(ProtectedJobS3OutputConfigurationOutput var1);

        default public Builder s3(Consumer<ProtectedJobS3OutputConfigurationOutput.Builder> s3) {
            return this.s3((ProtectedJobS3OutputConfigurationOutput)((ProtectedJobS3OutputConfigurationOutput.Builder)ProtectedJobS3OutputConfigurationOutput.builder().applyMutation(s3)).build());
        }

        public Builder member(ProtectedJobMemberOutputConfigurationOutput var1);

        default public Builder member(Consumer<ProtectedJobMemberOutputConfigurationOutput.Builder> member) {
            return this.member((ProtectedJobMemberOutputConfigurationOutput)((ProtectedJobMemberOutputConfigurationOutput.Builder)ProtectedJobMemberOutputConfigurationOutput.builder().applyMutation(member)).build());
        }
    }
}

