/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalyticsEngine {
    SPARK("SPARK"),
    CLEAN_ROOMS_SQL("CLEAN_ROOMS_SQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalyticsEngine> VALUE_MAP;
    private final String value;

    private AnalyticsEngine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalyticsEngine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalyticsEngine> knownValues() {
        EnumSet<AnalyticsEngine> knownValues = EnumSet.allOf(AnalyticsEngine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalyticsEngine.class, AnalyticsEngine::toString);
    }
}

