/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.MembershipSummary;
import software.amazon.awssdk.services.cleanrooms.model.MembershipSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembershipsResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListMembershipsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMembershipsResponse.getter(ListMembershipsResponse::nextToken)).setter(ListMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MembershipSummary>> MEMBERSHIP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("membershipSummaries").getter(ListMembershipsResponse.getter(ListMembershipsResponse::membershipSummaries)).setter(ListMembershipsResponse.setter(Builder::membershipSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MembershipSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MEMBERSHIP_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMembershipsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MembershipSummary> membershipSummaries;

    private ListMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.membershipSummaries = builder.membershipSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMembershipSummaries() {
        return this.membershipSummaries != null && !(this.membershipSummaries instanceof SdkAutoConstructList);
    }

    public final List<MembershipSummary> membershipSummaries() {
        return this.membershipSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembershipSummaries() ? this.membershipSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembershipsResponse)) {
            return false;
        }
        ListMembershipsResponse other = (ListMembershipsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMembershipSummaries() == other.hasMembershipSummaries() && Objects.equals(this.membershipSummaries(), other.membershipSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListMembershipsResponse").add("NextToken", (Object)this.nextToken()).add("MembershipSummaries", this.hasMembershipSummaries() ? this.membershipSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "membershipSummaries": {
                return Optional.ofNullable(clazz.cast(this.membershipSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("membershipSummaries", MEMBERSHIP_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembershipsResponse, T> g) {
        return obj -> g.apply((ListMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MembershipSummary> membershipSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembershipsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.membershipSummaries(model.membershipSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MembershipSummary.Builder> getMembershipSummaries() {
            List<MembershipSummary.Builder> result = MembershipSummaryListCopier.copyToBuilder(this.membershipSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembershipSummaries(Collection<MembershipSummary.BuilderImpl> membershipSummaries) {
            this.membershipSummaries = MembershipSummaryListCopier.copyFromBuilder(membershipSummaries);
        }

        @Override
        public final Builder membershipSummaries(Collection<MembershipSummary> membershipSummaries) {
            this.membershipSummaries = MembershipSummaryListCopier.copy(membershipSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipSummaries(MembershipSummary ... membershipSummaries) {
            this.membershipSummaries(Arrays.asList(membershipSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipSummaries(Consumer<MembershipSummary.Builder> ... membershipSummaries) {
            this.membershipSummaries(Stream.of(membershipSummaries).map(c -> (MembershipSummary)((MembershipSummary.Builder)MembershipSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMembershipsResponse build() {
            return new ListMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMembershipsResponse> {
        public Builder nextToken(String var1);

        public Builder membershipSummaries(Collection<MembershipSummary> var1);

        public Builder membershipSummaries(MembershipSummary ... var1);

        public Builder membershipSummaries(Consumer<MembershipSummary.Builder> ... var1);
    }
}

