/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryDistributeOutputConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryMemberOutputConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryS3OutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQueryOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQueryOutputConfiguration> {
    private static final SdkField<ProtectedQueryS3OutputConfiguration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(ProtectedQueryOutputConfiguration.getter(ProtectedQueryOutputConfiguration::s3)).setter(ProtectedQueryOutputConfiguration.setter(Builder::s3)).constructor(ProtectedQueryS3OutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<ProtectedQueryMemberOutputConfiguration> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("member").getter(ProtectedQueryOutputConfiguration.getter(ProtectedQueryOutputConfiguration::member)).setter(ProtectedQueryOutputConfiguration.setter(Builder::member)).constructor(ProtectedQueryMemberOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build();
    private static final SdkField<ProtectedQueryDistributeOutputConfiguration> DISTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distribute").getter(ProtectedQueryOutputConfiguration.getter(ProtectedQueryOutputConfiguration::distribute)).setter(ProtectedQueryOutputConfiguration.setter(Builder::distribute)).constructor(ProtectedQueryDistributeOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_FIELD, DISTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedQueryOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProtectedQueryS3OutputConfiguration s3;
    private final ProtectedQueryMemberOutputConfiguration member;
    private final ProtectedQueryDistributeOutputConfiguration distribute;
    private final Type type;

    private ProtectedQueryOutputConfiguration(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.member = builder.member;
        this.distribute = builder.distribute;
        this.type = builder.type;
    }

    public final ProtectedQueryS3OutputConfiguration s3() {
        return this.s3;
    }

    public final ProtectedQueryMemberOutputConfiguration member() {
        return this.member;
    }

    public final ProtectedQueryDistributeOutputConfiguration distribute() {
        return this.distribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.distribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryOutputConfiguration)) {
            return false;
        }
        ProtectedQueryOutputConfiguration other = (ProtectedQueryOutputConfiguration)obj;
        return Objects.equals(this.s3(), other.s3()) && Objects.equals(this.member(), other.member()) && Objects.equals(this.distribute(), other.distribute());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQueryOutputConfiguration").add("S3", (Object)this.s3()).add("Member", (Object)this.member()).add("Distribute", (Object)this.distribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "distribute": {
                return Optional.ofNullable(clazz.cast(this.distribute()));
            }
        }
        return Optional.empty();
    }

    public static ProtectedQueryOutputConfiguration fromS3(ProtectedQueryS3OutputConfiguration s3) {
        return (ProtectedQueryOutputConfiguration)ProtectedQueryOutputConfiguration.builder().s3(s3).build();
    }

    public static ProtectedQueryOutputConfiguration fromS3(Consumer<ProtectedQueryS3OutputConfiguration.Builder> s3) {
        ProtectedQueryS3OutputConfiguration.Builder builder = ProtectedQueryS3OutputConfiguration.builder();
        s3.accept(builder);
        return ProtectedQueryOutputConfiguration.fromS3((ProtectedQueryS3OutputConfiguration)builder.build());
    }

    public static ProtectedQueryOutputConfiguration fromMember(ProtectedQueryMemberOutputConfiguration member) {
        return (ProtectedQueryOutputConfiguration)ProtectedQueryOutputConfiguration.builder().member(member).build();
    }

    public static ProtectedQueryOutputConfiguration fromMember(Consumer<ProtectedQueryMemberOutputConfiguration.Builder> member) {
        ProtectedQueryMemberOutputConfiguration.Builder builder = ProtectedQueryMemberOutputConfiguration.builder();
        member.accept(builder);
        return ProtectedQueryOutputConfiguration.fromMember((ProtectedQueryMemberOutputConfiguration)builder.build());
    }

    public static ProtectedQueryOutputConfiguration fromDistribute(ProtectedQueryDistributeOutputConfiguration distribute) {
        return (ProtectedQueryOutputConfiguration)ProtectedQueryOutputConfiguration.builder().distribute(distribute).build();
    }

    public static ProtectedQueryOutputConfiguration fromDistribute(Consumer<ProtectedQueryDistributeOutputConfiguration.Builder> distribute) {
        ProtectedQueryDistributeOutputConfiguration.Builder builder = ProtectedQueryDistributeOutputConfiguration.builder();
        distribute.accept(builder);
        return ProtectedQueryOutputConfiguration.fromDistribute((ProtectedQueryDistributeOutputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3", S3_FIELD);
        map.put("member", MEMBER_FIELD);
        map.put("distribute", DISTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryOutputConfiguration, T> g) {
        return obj -> g.apply((ProtectedQueryOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        MEMBER,
        DISTRIBUTE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProtectedQueryS3OutputConfiguration s3;
        private ProtectedQueryMemberOutputConfiguration member;
        private ProtectedQueryDistributeOutputConfiguration distribute;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryOutputConfiguration model) {
            this.s3(model.s3);
            this.member(model.member);
            this.distribute(model.distribute);
        }

        public final ProtectedQueryS3OutputConfiguration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(ProtectedQueryS3OutputConfiguration.BuilderImpl s3) {
            ProtectedQueryS3OutputConfiguration oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(ProtectedQueryS3OutputConfiguration s3) {
            ProtectedQueryS3OutputConfiguration oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final ProtectedQueryMemberOutputConfiguration.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(ProtectedQueryMemberOutputConfiguration.BuilderImpl member) {
            ProtectedQueryMemberOutputConfiguration oldValue = this.member;
            this.member = member != null ? member.build() : null;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
        }

        @Override
        public final Builder member(ProtectedQueryMemberOutputConfiguration member) {
            ProtectedQueryMemberOutputConfiguration oldValue = this.member;
            this.member = member;
            this.handleUnionValueChange(Type.MEMBER, oldValue, this.member);
            return this;
        }

        public final ProtectedQueryDistributeOutputConfiguration.Builder getDistribute() {
            return this.distribute != null ? this.distribute.toBuilder() : null;
        }

        public final void setDistribute(ProtectedQueryDistributeOutputConfiguration.BuilderImpl distribute) {
            ProtectedQueryDistributeOutputConfiguration oldValue = this.distribute;
            this.distribute = distribute != null ? distribute.build() : null;
            this.handleUnionValueChange(Type.DISTRIBUTE, oldValue, this.distribute);
        }

        @Override
        public final Builder distribute(ProtectedQueryDistributeOutputConfiguration distribute) {
            ProtectedQueryDistributeOutputConfiguration oldValue = this.distribute;
            this.distribute = distribute;
            this.handleUnionValueChange(Type.DISTRIBUTE, oldValue, this.distribute);
            return this;
        }

        public ProtectedQueryOutputConfiguration build() {
            return new ProtectedQueryOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQueryOutputConfiguration> {
        public Builder s3(ProtectedQueryS3OutputConfiguration var1);

        default public Builder s3(Consumer<ProtectedQueryS3OutputConfiguration.Builder> s3) {
            return this.s3((ProtectedQueryS3OutputConfiguration)((ProtectedQueryS3OutputConfiguration.Builder)ProtectedQueryS3OutputConfiguration.builder().applyMutation(s3)).build());
        }

        public Builder member(ProtectedQueryMemberOutputConfiguration var1);

        default public Builder member(Consumer<ProtectedQueryMemberOutputConfiguration.Builder> member) {
            return this.member((ProtectedQueryMemberOutputConfiguration)((ProtectedQueryMemberOutputConfiguration.Builder)ProtectedQueryMemberOutputConfiguration.builder().applyMutation(member)).build());
        }

        public Builder distribute(ProtectedQueryDistributeOutputConfiguration var1);

        default public Builder distribute(Consumer<ProtectedQueryDistributeOutputConfiguration.Builder> distribute) {
            return this.distribute((ProtectedQueryDistributeOutputConfiguration)((ProtectedQueryDistributeOutputConfiguration.Builder)ProtectedQueryDistributeOutputConfiguration.builder().applyMutation(distribute)).build());
        }
    }
}

