/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationConfiguredAudienceModelAssociationRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, GetCollaborationConfiguredAudienceModelAssociationRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationConfiguredAudienceModelAssociationRequest.getter(GetCollaborationConfiguredAudienceModelAssociationRequest::collaborationIdentifier)).setter(GetCollaborationConfiguredAudienceModelAssociationRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelAssociationIdentifier").getter(GetCollaborationConfiguredAudienceModelAssociationRequest.getter(GetCollaborationConfiguredAudienceModelAssociationRequest::configuredAudienceModelAssociationIdentifier)).setter(GetCollaborationConfiguredAudienceModelAssociationRequest.setter(Builder::configuredAudienceModelAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredAudienceModelAssociationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCollaborationConfiguredAudienceModelAssociationRequest.memberNameToFieldInitializer();
    private final String collaborationIdentifier;
    private final String configuredAudienceModelAssociationIdentifier;

    private GetCollaborationConfiguredAudienceModelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.configuredAudienceModelAssociationIdentifier = builder.configuredAudienceModelAssociationIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String configuredAudienceModelAssociationIdentifier() {
        return this.configuredAudienceModelAssociationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelAssociationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationConfiguredAudienceModelAssociationRequest)) {
            return false;
        }
        GetCollaborationConfiguredAudienceModelAssociationRequest other = (GetCollaborationConfiguredAudienceModelAssociationRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.configuredAudienceModelAssociationIdentifier(), other.configuredAudienceModelAssociationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationConfiguredAudienceModelAssociationRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("ConfiguredAudienceModelAssociationIdentifier", (Object)this.configuredAudienceModelAssociationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "configuredAudienceModelAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelAssociationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("configuredAudienceModelAssociationIdentifier", CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationConfiguredAudienceModelAssociationRequest, T> g) {
        return obj -> g.apply((GetCollaborationConfiguredAudienceModelAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private String configuredAudienceModelAssociationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationConfiguredAudienceModelAssociationRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.configuredAudienceModelAssociationIdentifier(model.configuredAudienceModelAssociationIdentifier);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getConfiguredAudienceModelAssociationIdentifier() {
            return this.configuredAudienceModelAssociationIdentifier;
        }

        public final void setConfiguredAudienceModelAssociationIdentifier(String configuredAudienceModelAssociationIdentifier) {
            this.configuredAudienceModelAssociationIdentifier = configuredAudienceModelAssociationIdentifier;
        }

        @Override
        public final Builder configuredAudienceModelAssociationIdentifier(String configuredAudienceModelAssociationIdentifier) {
            this.configuredAudienceModelAssociationIdentifier = configuredAudienceModelAssociationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationConfiguredAudienceModelAssociationRequest build() {
            return new GetCollaborationConfiguredAudienceModelAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationConfiguredAudienceModelAssociationRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder configuredAudienceModelAssociationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

