/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ComputeConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySQLParameters;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartProtectedQueryRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, StartProtectedQueryRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StartProtectedQueryRequest.getter(StartProtectedQueryRequest::typeAsString)).setter(StartProtectedQueryRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(StartProtectedQueryRequest.getter(StartProtectedQueryRequest::membershipIdentifier)).setter(StartProtectedQueryRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqlParameters").getter(StartProtectedQueryRequest.getter(StartProtectedQueryRequest::sqlParameters)).setter(StartProtectedQueryRequest.setter(Builder::sqlParameters)).constructor(ProtectedQuerySQLParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()}).build();
    private static final SdkField<ProtectedQueryResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultConfiguration").getter(StartProtectedQueryRequest.getter(StartProtectedQueryRequest::resultConfiguration)).setter(StartProtectedQueryRequest.setter(Builder::resultConfiguration)).constructor(ProtectedQueryResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build()}).build();
    private static final SdkField<ComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfiguration").getter(StartProtectedQueryRequest.getter(StartProtectedQueryRequest::computeConfiguration)).setter(StartProtectedQueryRequest.setter(Builder::computeConfiguration)).constructor(ComputeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, SQL_PARAMETERS_FIELD, RESULT_CONFIGURATION_FIELD, COMPUTE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartProtectedQueryRequest.memberNameToFieldInitializer();
    private final String type;
    private final String membershipIdentifier;
    private final ProtectedQuerySQLParameters sqlParameters;
    private final ProtectedQueryResultConfiguration resultConfiguration;
    private final ComputeConfiguration computeConfiguration;

    private StartProtectedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.sqlParameters = builder.sqlParameters;
        this.resultConfiguration = builder.resultConfiguration;
        this.computeConfiguration = builder.computeConfiguration;
    }

    public final ProtectedQueryType type() {
        return ProtectedQueryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final ProtectedQuerySQLParameters sqlParameters() {
        return this.sqlParameters;
    }

    public final ProtectedQueryResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public final ComputeConfiguration computeConfiguration() {
        return this.computeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProtectedQueryRequest)) {
            return false;
        }
        StartProtectedQueryRequest other = (StartProtectedQueryRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.sqlParameters(), other.sqlParameters()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.computeConfiguration(), other.computeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartProtectedQueryRequest").add("Type", (Object)this.typeAsString()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("SqlParameters", (Object)(this.sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("ResultConfiguration", (Object)this.resultConfiguration()).add("ComputeConfiguration", (Object)this.computeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "sqlParameters": {
                return Optional.ofNullable(clazz.cast(this.sqlParameters()));
            }
            case "resultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "computeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("sqlParameters", SQL_PARAMETERS_FIELD);
        map.put("resultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProtectedQueryRequest, T> g) {
        return obj -> g.apply((StartProtectedQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String type;
        private String membershipIdentifier;
        private ProtectedQuerySQLParameters sqlParameters;
        private ProtectedQueryResultConfiguration resultConfiguration;
        private ComputeConfiguration computeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProtectedQueryRequest model) {
            super(model);
            this.type(model.type);
            this.membershipIdentifier(model.membershipIdentifier);
            this.sqlParameters(model.sqlParameters);
            this.resultConfiguration(model.resultConfiguration);
            this.computeConfiguration(model.computeConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectedQueryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return this.sqlParameters != null ? this.sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final ProtectedQueryResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedQueryResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ComputeConfiguration.Builder getComputeConfiguration() {
            return this.computeConfiguration != null ? this.computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProtectedQueryRequest build() {
            return new StartProtectedQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartProtectedQueryRequest> {
        public Builder type(String var1);

        public Builder type(ProtectedQueryType var1);

        public Builder membershipIdentifier(String var1);

        public Builder sqlParameters(ProtectedQuerySQLParameters var1);

        default public Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return this.sqlParameters((ProtectedQuerySQLParameters)((ProtectedQuerySQLParameters.Builder)ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters)).build());
        }

        public Builder resultConfiguration(ProtectedQueryResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ProtectedQueryResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ProtectedQueryResultConfiguration)((ProtectedQueryResultConfiguration.Builder)ProtectedQueryResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder computeConfiguration(ComputeConfiguration var1);

        default public Builder computeConfiguration(Consumer<ComputeConfiguration.Builder> computeConfiguration) {
            return this.computeConfiguration((ComputeConfiguration)((ComputeConfiguration.Builder)ComputeConfiguration.builder().applyMutation(computeConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

