/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsResponse;
import software.amazon.awssdk.services.cleanrooms.model.MembershipSummary;

public class ListMembershipsIterable
implements SdkIterable<ListMembershipsResponse> {
    private final CleanRoomsClient client;
    private final ListMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembershipsIterable(CleanRoomsClient client, ListMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMembershipsResponseFetcher();
    }

    public Iterator<ListMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MembershipSummary> membershipSummaries() {
        Function<ListMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.membershipSummaries() != null) {
                return response.membershipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMembershipsResponseFetcher
    implements SyncPageFetcher<ListMembershipsResponse> {
        private ListMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMembershipsResponse nextPage(ListMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListMembershipsIterable.this.client.listMemberships(ListMembershipsIterable.this.firstRequest);
            }
            return ListMembershipsIterable.this.client.listMemberships((ListMembershipsRequest)((Object)ListMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

