/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.MLPaymentConfig;
import software.amazon.awssdk.services.cleanrooms.model.QueryComputePaymentConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PaymentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PaymentConfiguration> {
    private static final SdkField<QueryComputePaymentConfig> QUERY_COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryCompute").getter(PaymentConfiguration.getter(PaymentConfiguration::queryCompute)).setter(PaymentConfiguration.setter(Builder::queryCompute)).constructor(QueryComputePaymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCompute").build()}).build();
    private static final SdkField<MLPaymentConfig> MACHINE_LEARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("machineLearning").getter(PaymentConfiguration.getter(PaymentConfiguration::machineLearning)).setter(PaymentConfiguration.setter(Builder::machineLearning)).constructor(MLPaymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("machineLearning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_COMPUTE_FIELD, MACHINE_LEARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PaymentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final QueryComputePaymentConfig queryCompute;
    private final MLPaymentConfig machineLearning;

    private PaymentConfiguration(BuilderImpl builder) {
        this.queryCompute = builder.queryCompute;
        this.machineLearning = builder.machineLearning;
    }

    public final QueryComputePaymentConfig queryCompute() {
        return this.queryCompute;
    }

    public final MLPaymentConfig machineLearning() {
        return this.machineLearning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryCompute());
        hashCode = 31 * hashCode + Objects.hashCode(this.machineLearning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentConfiguration)) {
            return false;
        }
        PaymentConfiguration other = (PaymentConfiguration)obj;
        return Objects.equals(this.queryCompute(), other.queryCompute()) && Objects.equals(this.machineLearning(), other.machineLearning());
    }

    public final String toString() {
        return ToString.builder((String)"PaymentConfiguration").add("QueryCompute", (Object)this.queryCompute()).add("MachineLearning", (Object)this.machineLearning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryCompute": {
                return Optional.ofNullable(clazz.cast(this.queryCompute()));
            }
            case "machineLearning": {
                return Optional.ofNullable(clazz.cast(this.machineLearning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryCompute", QUERY_COMPUTE_FIELD);
        map.put("machineLearning", MACHINE_LEARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaymentConfiguration, T> g) {
        return obj -> g.apply((PaymentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private QueryComputePaymentConfig queryCompute;
        private MLPaymentConfig machineLearning;

        private BuilderImpl() {
        }

        private BuilderImpl(PaymentConfiguration model) {
            this.queryCompute(model.queryCompute);
            this.machineLearning(model.machineLearning);
        }

        public final QueryComputePaymentConfig.Builder getQueryCompute() {
            return this.queryCompute != null ? this.queryCompute.toBuilder() : null;
        }

        public final void setQueryCompute(QueryComputePaymentConfig.BuilderImpl queryCompute) {
            this.queryCompute = queryCompute != null ? queryCompute.build() : null;
        }

        @Override
        public final Builder queryCompute(QueryComputePaymentConfig queryCompute) {
            this.queryCompute = queryCompute;
            return this;
        }

        public final MLPaymentConfig.Builder getMachineLearning() {
            return this.machineLearning != null ? this.machineLearning.toBuilder() : null;
        }

        public final void setMachineLearning(MLPaymentConfig.BuilderImpl machineLearning) {
            this.machineLearning = machineLearning != null ? machineLearning.build() : null;
        }

        @Override
        public final Builder machineLearning(MLPaymentConfig machineLearning) {
            this.machineLearning = machineLearning;
            return this;
        }

        public PaymentConfiguration build() {
            return new PaymentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PaymentConfiguration> {
        public Builder queryCompute(QueryComputePaymentConfig var1);

        default public Builder queryCompute(Consumer<QueryComputePaymentConfig.Builder> queryCompute) {
            return this.queryCompute((QueryComputePaymentConfig)((QueryComputePaymentConfig.Builder)QueryComputePaymentConfig.builder().applyMutation(queryCompute)).build());
        }

        public Builder machineLearning(MLPaymentConfig var1);

        default public Builder machineLearning(Consumer<MLPaymentConfig.Builder> machineLearning) {
            return this.machineLearning((MLPaymentConfig)((MLPaymentConfig.Builder)MLPaymentConfig.builder().applyMutation(machineLearning)).build());
        }
    }
}

