/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.ResultFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQueryS3OutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQueryS3OutputConfiguration> {
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultFormat").getter(ProtectedQueryS3OutputConfiguration.getter(ProtectedQueryS3OutputConfiguration::resultFormatAsString)).setter(ProtectedQueryS3OutputConfiguration.setter(Builder::resultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFormat").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(ProtectedQueryS3OutputConfiguration.getter(ProtectedQueryS3OutputConfiguration::bucket)).setter(ProtectedQueryS3OutputConfiguration.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(ProtectedQueryS3OutputConfiguration.getter(ProtectedQueryS3OutputConfiguration::keyPrefix)).setter(ProtectedQueryS3OutputConfiguration.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<Boolean> SINGLE_FILE_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("singleFileOutput").getter(ProtectedQueryS3OutputConfiguration.getter(ProtectedQueryS3OutputConfiguration::singleFileOutput)).setter(ProtectedQueryS3OutputConfiguration.setter(Builder::singleFileOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleFileOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FORMAT_FIELD, BUCKET_FIELD, KEY_PREFIX_FIELD, SINGLE_FILE_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resultFormat", RESULT_FORMAT_FIELD);
            this.put("bucket", BUCKET_FIELD);
            this.put("keyPrefix", KEY_PREFIX_FIELD);
            this.put("singleFileOutput", SINGLE_FILE_OUTPUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resultFormat;
    private final String bucket;
    private final String keyPrefix;
    private final Boolean singleFileOutput;

    private ProtectedQueryS3OutputConfiguration(BuilderImpl builder) {
        this.resultFormat = builder.resultFormat;
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.singleFileOutput = builder.singleFileOutput;
    }

    public final ResultFormat resultFormat() {
        return ResultFormat.fromValue(this.resultFormat);
    }

    public final String resultFormatAsString() {
        return this.resultFormat;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String keyPrefix() {
        return this.keyPrefix;
    }

    public final Boolean singleFileOutput() {
        return this.singleFileOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleFileOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryS3OutputConfiguration)) {
            return false;
        }
        ProtectedQueryS3OutputConfiguration other = (ProtectedQueryS3OutputConfiguration)obj;
        return Objects.equals(this.resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.singleFileOutput(), other.singleFileOutput());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQueryS3OutputConfiguration").add("ResultFormat", (Object)this.resultFormatAsString()).add("Bucket", (Object)this.bucket()).add("KeyPrefix", (Object)this.keyPrefix()).add("SingleFileOutput", (Object)this.singleFileOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resultFormat": {
                return Optional.ofNullable(clazz.cast(this.resultFormatAsString()));
            }
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "singleFileOutput": {
                return Optional.ofNullable(clazz.cast(this.singleFileOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryS3OutputConfiguration, T> g) {
        return obj -> g.apply((ProtectedQueryS3OutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultFormat;
        private String bucket;
        private String keyPrefix;
        private Boolean singleFileOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryS3OutputConfiguration model) {
            this.resultFormat(model.resultFormat);
            this.bucket(model.bucket);
            this.keyPrefix(model.keyPrefix);
            this.singleFileOutput(model.singleFileOutput);
        }

        public final String getResultFormat() {
            return this.resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormat resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final Boolean getSingleFileOutput() {
            return this.singleFileOutput;
        }

        public final void setSingleFileOutput(Boolean singleFileOutput) {
            this.singleFileOutput = singleFileOutput;
        }

        @Override
        public final Builder singleFileOutput(Boolean singleFileOutput) {
            this.singleFileOutput = singleFileOutput;
            return this;
        }

        public ProtectedQueryS3OutputConfiguration build() {
            return new ProtectedQueryS3OutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQueryS3OutputConfiguration> {
        public Builder resultFormat(String var1);

        public Builder resultFormat(ResultFormat var1);

        public Builder bucket(String var1);

        public Builder keyPrefix(String var1);

        public Builder singleFileOutput(Boolean var1);
    }
}

