/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AdditionalAnalyses;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleListJoinColumnsListCopier;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperator;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperatorsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRuleList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRuleList> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("joinColumns").getter(AnalysisRuleList.getter(AnalysisRuleList::joinColumns)).setter(AnalysisRuleList.setter(Builder::joinColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_JOIN_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedJoinOperators").getter(AnalysisRuleList.getter(AnalysisRuleList::allowedJoinOperatorsAsStrings)).setter(AnalysisRuleList.setter(Builder::allowedJoinOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedJoinOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIST_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listColumns").getter(AnalysisRuleList.getter(AnalysisRuleList::listColumns)).setter(AnalysisRuleList.setter(Builder::listColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalAnalyses").getter(AnalysisRuleList.getter(AnalysisRuleList::additionalAnalysesAsString)).setter(AnalysisRuleList.setter(Builder::additionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD, ALLOWED_JOIN_OPERATORS_FIELD, LIST_COLUMNS_FIELD, ADDITIONAL_ANALYSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> joinColumns;
    private final List<String> allowedJoinOperators;
    private final List<String> listColumns;
    private final String additionalAnalyses;

    private AnalysisRuleList(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.allowedJoinOperators = builder.allowedJoinOperators;
        this.listColumns = builder.listColumns;
        this.additionalAnalyses = builder.additionalAnalyses;
    }

    public final boolean hasJoinColumns() {
        return this.joinColumns != null && !(this.joinColumns instanceof SdkAutoConstructList);
    }

    public final List<String> joinColumns() {
        return this.joinColumns;
    }

    public final List<JoinOperator> allowedJoinOperators() {
        return JoinOperatorsListCopier.copyStringToEnum(this.allowedJoinOperators);
    }

    public final boolean hasAllowedJoinOperators() {
        return this.allowedJoinOperators != null && !(this.allowedJoinOperators instanceof SdkAutoConstructList);
    }

    public final List<String> allowedJoinOperatorsAsStrings() {
        return this.allowedJoinOperators;
    }

    public final boolean hasListColumns() {
        return this.listColumns != null && !(this.listColumns instanceof SdkAutoConstructList);
    }

    public final List<String> listColumns() {
        return this.listColumns;
    }

    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(this.additionalAnalyses);
    }

    public final String additionalAnalysesAsString() {
        return this.additionalAnalyses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinColumns() ? this.joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListColumns() ? this.listColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAnalysesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleList)) {
            return false;
        }
        AnalysisRuleList other = (AnalysisRuleList)obj;
        return this.hasJoinColumns() == other.hasJoinColumns() && Objects.equals(this.joinColumns(), other.joinColumns()) && this.hasAllowedJoinOperators() == other.hasAllowedJoinOperators() && Objects.equals(this.allowedJoinOperatorsAsStrings(), other.allowedJoinOperatorsAsStrings()) && this.hasListColumns() == other.hasListColumns() && Objects.equals(this.listColumns(), other.listColumns()) && Objects.equals(this.additionalAnalysesAsString(), other.additionalAnalysesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRuleList").add("JoinColumns", this.hasJoinColumns() ? this.joinColumns() : null).add("AllowedJoinOperators", this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null).add("ListColumns", this.hasListColumns() ? this.listColumns() : null).add("AdditionalAnalyses", (Object)this.additionalAnalysesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "joinColumns": {
                return Optional.ofNullable(clazz.cast(this.joinColumns()));
            }
            case "allowedJoinOperators": {
                return Optional.ofNullable(clazz.cast(this.allowedJoinOperatorsAsStrings()));
            }
            case "listColumns": {
                return Optional.ofNullable(clazz.cast(this.listColumns()));
            }
            case "additionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.additionalAnalysesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleList, T> g) {
        return obj -> g.apply((AnalysisRuleList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedJoinOperators = DefaultSdkAutoConstructList.getInstance();
        private List<String> listColumns = DefaultSdkAutoConstructList.getInstance();
        private String additionalAnalyses;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleList model) {
            this.joinColumns(model.joinColumns);
            this.allowedJoinOperatorsWithStrings(model.allowedJoinOperators);
            this.listColumns(model.listColumns);
            this.additionalAnalyses(model.additionalAnalyses);
        }

        public final Collection<String> getJoinColumns() {
            if (this.joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String ... joinColumns) {
            this.joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final Collection<String> getAllowedJoinOperators() {
            if (this.allowedJoinOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedJoinOperators;
        }

        public final void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
        }

        @Override
        public final Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperatorsWithStrings(String ... allowedJoinOperators) {
            this.allowedJoinOperatorsWithStrings(Arrays.asList(allowedJoinOperators));
            return this;
        }

        @Override
        public final Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copyEnumToString(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperators(JoinOperator ... allowedJoinOperators) {
            this.allowedJoinOperators(Arrays.asList(allowedJoinOperators));
            return this;
        }

        public final Collection<String> getListColumns() {
            if (this.listColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listColumns;
        }

        public final void setListColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
        }

        @Override
        public final Builder listColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listColumns(String ... listColumns) {
            this.listColumns(Arrays.asList(listColumns));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return this.additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public AnalysisRuleList build() {
            return new AnalysisRuleList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRuleList> {
        public Builder joinColumns(Collection<String> var1);

        public Builder joinColumns(String ... var1);

        public Builder allowedJoinOperatorsWithStrings(Collection<String> var1);

        public Builder allowedJoinOperatorsWithStrings(String ... var1);

        public Builder allowedJoinOperators(Collection<JoinOperator> var1);

        public Builder allowedJoinOperators(JoinOperator ... var1);

        public Builder listColumns(Collection<String> var1);

        public Builder listColumns(String ... var1);

        public Builder additionalAnalyses(String var1);

        public Builder additionalAnalyses(AdditionalAnalyses var1);
    }
}

