/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary;

public class ListProtectedQueriesIterable
implements SdkIterable<ListProtectedQueriesResponse> {
    private final CleanRoomsClient client;
    private final ListProtectedQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectedQueriesIterable(CleanRoomsClient client, ListProtectedQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtectedQueriesResponseFetcher();
    }

    public Iterator<ListProtectedQueriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtectedQuerySummary> protectedQueries() {
        Function<ListProtectedQueriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.protectedQueries() != null) {
                return response.protectedQueries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtectedQueriesResponseFetcher
    implements SyncPageFetcher<ListProtectedQueriesResponse> {
        private ListProtectedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectedQueriesResponse nextPage(ListProtectedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedQueriesIterable.this.client.listProtectedQueries(ListProtectedQueriesIterable.this.firstRequest);
            }
            return ListProtectedQueriesIterable.this.client.listProtectedQueries((ListProtectedQueriesRequest)((Object)ListProtectedQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

