/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdMappingTableRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdateIdMappingTableRequest> {
    private static final SdkField<String> ID_MAPPING_TABLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idMappingTableIdentifier").getter(UpdateIdMappingTableRequest.getter(UpdateIdMappingTableRequest::idMappingTableIdentifier)).setter(UpdateIdMappingTableRequest.setter(Builder::idMappingTableIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("idMappingTableIdentifier").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(UpdateIdMappingTableRequest.getter(UpdateIdMappingTableRequest::membershipIdentifier)).setter(UpdateIdMappingTableRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateIdMappingTableRequest.getter(UpdateIdMappingTableRequest::description)).setter(UpdateIdMappingTableRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(UpdateIdMappingTableRequest.getter(UpdateIdMappingTableRequest::kmsKeyArn)).setter(UpdateIdMappingTableRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_MAPPING_TABLE_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD));
    private final String idMappingTableIdentifier;
    private final String membershipIdentifier;
    private final String description;
    private final String kmsKeyArn;

    private UpdateIdMappingTableRequest(BuilderImpl builder) {
        super(builder);
        this.idMappingTableIdentifier = builder.idMappingTableIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String idMappingTableIdentifier() {
        return this.idMappingTableIdentifier;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.idMappingTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdMappingTableRequest)) {
            return false;
        }
        UpdateIdMappingTableRequest other = (UpdateIdMappingTableRequest)((Object)obj);
        return Objects.equals(this.idMappingTableIdentifier(), other.idMappingTableIdentifier()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIdMappingTableRequest").add("IdMappingTableIdentifier", (Object)this.idMappingTableIdentifier()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Description", (Object)this.description()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "idMappingTableIdentifier": {
                return Optional.ofNullable(clazz.cast(this.idMappingTableIdentifier()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdMappingTableRequest, T> g) {
        return obj -> g.apply((UpdateIdMappingTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String idMappingTableIdentifier;
        private String membershipIdentifier;
        private String description;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdMappingTableRequest model) {
            super(model);
            this.idMappingTableIdentifier(model.idMappingTableIdentifier);
            this.membershipIdentifier(model.membershipIdentifier);
            this.description(model.description);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getIdMappingTableIdentifier() {
            return this.idMappingTableIdentifier;
        }

        public final void setIdMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
        }

        @Override
        public final Builder idMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdMappingTableRequest build() {
            return new UpdateIdMappingTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIdMappingTableRequest> {
        public Builder idMappingTableIdentifier(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder description(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

