/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteConfiguredTableAssociationAnalysisRuleRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, DeleteConfiguredTableAssociationAnalysisRuleRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(DeleteConfiguredTableAssociationAnalysisRuleRequest.getter(DeleteConfiguredTableAssociationAnalysisRuleRequest::membershipIdentifier)).setter(DeleteConfiguredTableAssociationAnalysisRuleRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableAssociationIdentifier").getter(DeleteConfiguredTableAssociationAnalysisRuleRequest.getter(DeleteConfiguredTableAssociationAnalysisRuleRequest::configuredTableAssociationIdentifier)).setter(DeleteConfiguredTableAssociationAnalysisRuleRequest.setter(Builder::configuredTableAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableAssociationIdentifier").build()}).build();
    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisRuleType").getter(DeleteConfiguredTableAssociationAnalysisRuleRequest.getter(DeleteConfiguredTableAssociationAnalysisRuleRequest::analysisRuleTypeAsString)).setter(DeleteConfiguredTableAssociationAnalysisRuleRequest.setter(Builder::analysisRuleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisRuleType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD));
    private final String membershipIdentifier;
    private final String configuredTableAssociationIdentifier;
    private final String analysisRuleType;

    private DeleteConfiguredTableAssociationAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredTableAssociationIdentifier = builder.configuredTableAssociationIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String configuredTableAssociationIdentifier() {
        return this.configuredTableAssociationIdentifier;
    }

    public final ConfiguredTableAssociationAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAssociationAnalysisRuleType.fromValue(this.analysisRuleType);
    }

    public final String analysisRuleTypeAsString() {
        return this.analysisRuleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisRuleTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfiguredTableAssociationAnalysisRuleRequest)) {
            return false;
        }
        DeleteConfiguredTableAssociationAnalysisRuleRequest other = (DeleteConfiguredTableAssociationAnalysisRuleRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.configuredTableAssociationIdentifier(), other.configuredTableAssociationIdentifier()) && Objects.equals(this.analysisRuleTypeAsString(), other.analysisRuleTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteConfiguredTableAssociationAnalysisRuleRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("ConfiguredTableAssociationIdentifier", (Object)this.configuredTableAssociationIdentifier()).add("AnalysisRuleType", (Object)this.analysisRuleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "configuredTableAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredTableAssociationIdentifier()));
            }
            case "analysisRuleType": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfiguredTableAssociationAnalysisRuleRequest, T> g) {
        return obj -> g.apply((DeleteConfiguredTableAssociationAnalysisRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String configuredTableAssociationIdentifier;
        private String analysisRuleType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfiguredTableAssociationAnalysisRuleRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.configuredTableAssociationIdentifier(model.configuredTableAssociationIdentifier);
            this.analysisRuleType(model.analysisRuleType);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredTableAssociationIdentifier() {
            return this.configuredTableAssociationIdentifier;
        }

        public final void setConfiguredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
        }

        @Override
        public final Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return this.analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAssociationAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfiguredTableAssociationAnalysisRuleRequest build() {
            return new DeleteConfiguredTableAssociationAnalysisRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteConfiguredTableAssociationAnalysisRuleRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder configuredTableAssociationIdentifier(String var1);

        public Builder analysisRuleType(String var1);

        public Builder analysisRuleType(ConfiguredTableAssociationAnalysisRuleType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

