/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleTypeListCopier;
import software.amazon.awssdk.services.cleanrooms.model.Column;
import software.amazon.awssdk.services.cleanrooms.model.ColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.SchemaStatusDetail;
import software.amazon.awssdk.services.cleanrooms.model.SchemaStatusDetailListCopier;
import software.amazon.awssdk.services.cleanrooms.model.SchemaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schema> {
    private static final SdkField<List<Column>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columns").getter(Schema.getter(Schema::columns)).setter(Schema.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Column>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitionKeys").getter(Schema.getter(Schema::partitionKeys)).setter(Schema.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Column::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRuleTypes").getter(Schema.getter(Schema::analysisRuleTypesAsStrings)).setter(Schema.setter(Builder::analysisRuleTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(Schema.getter(Schema::analysisMethodAsString)).setter(Schema.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(Schema.getter(Schema::creatorAccountId)).setter(Schema.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Schema.getter(Schema::name)).setter(Schema.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(Schema.getter(Schema::collaborationId)).setter(Schema.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationArn").getter(Schema.getter(Schema::collaborationArn)).setter(Schema.setter(Builder::collaborationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Schema.getter(Schema::description)).setter(Schema.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(Schema.getter(Schema::createTime)).setter(Schema.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(Schema.getter(Schema::updateTime)).setter(Schema.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Schema.getter(Schema::typeAsString)).setter(Schema.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<SchemaStatusDetail>> SCHEMA_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemaStatusDetails").getter(Schema.getter(Schema::schemaStatusDetails)).setter(Schema.setter(Builder::schemaStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaStatusDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaStatusDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, PARTITION_KEYS_FIELD, ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD, CREATOR_ACCOUNT_ID_FIELD, NAME_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, TYPE_FIELD, SCHEMA_STATUS_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;
    private final List<Column> partitionKeys;
    private final List<String> analysisRuleTypes;
    private final String analysisMethod;
    private final String creatorAccountId;
    private final String name;
    private final String collaborationId;
    private final String collaborationArn;
    private final String description;
    private final Instant createTime;
    private final Instant updateTime;
    private final String type;
    private final List<SchemaStatusDetail> schemaStatusDetails;

    private Schema(BuilderImpl builder) {
        this.columns = builder.columns;
        this.partitionKeys = builder.partitionKeys;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
        this.creatorAccountId = builder.creatorAccountId;
        this.name = builder.name;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.type = builder.type;
        this.schemaStatusDetails = builder.schemaStatusDetails;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<Column> columns() {
        return this.columns;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public final List<Column> partitionKeys() {
        return this.partitionKeys;
    }

    public final List<AnalysisRuleType> analysisRuleTypes() {
        return AnalysisRuleTypeListCopier.copyStringToEnum(this.analysisRuleTypes);
    }

    public final boolean hasAnalysisRuleTypes() {
        return this.analysisRuleTypes != null && !(this.analysisRuleTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisRuleTypesAsStrings() {
        return this.analysisRuleTypes;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final String name() {
        return this.name;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String collaborationArn() {
        return this.collaborationArn;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final SchemaType type() {
        return SchemaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasSchemaStatusDetails() {
        return this.schemaStatusDetails != null && !(this.schemaStatusDetails instanceof SdkAutoConstructList);
    }

    public final List<SchemaStatusDetail> schemaStatusDetails() {
        return this.schemaStatusDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaStatusDetails() ? this.schemaStatusDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)obj;
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && this.hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes() && Objects.equals(this.analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.collaborationArn(), other.collaborationArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasSchemaStatusDetails() == other.hasSchemaStatusDetails() && Objects.equals(this.schemaStatusDetails(), other.schemaStatusDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Schema").add("Columns", this.hasColumns() ? this.columns() : null).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("AnalysisRuleTypes", this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null).add("AnalysisMethod", (Object)this.analysisMethodAsString()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("Name", (Object)this.name()).add("CollaborationId", (Object)this.collaborationId()).add("CollaborationArn", (Object)this.collaborationArn()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Type", (Object)this.typeAsString()).add("SchemaStatusDetails", this.hasSchemaStatusDetails() ? this.schemaStatusDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "partitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "analysisRuleTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypesAsStrings()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "collaborationArn": {
                return Optional.ofNullable(clazz.cast(this.collaborationArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "schemaStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.schemaStatusDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schema, T> g) {
        return obj -> g.apply((Schema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Column> columns = DefaultSdkAutoConstructList.getInstance();
        private List<Column> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();
        private String analysisMethod;
        private String creatorAccountId;
        private String name;
        private String collaborationId;
        private String collaborationArn;
        private String description;
        private Instant createTime;
        private Instant updateTime;
        private String type;
        private List<SchemaStatusDetail> schemaStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Schema model) {
            this.columns(model.columns);
            this.partitionKeys(model.partitionKeys);
            this.analysisRuleTypesWithStrings(model.analysisRuleTypes);
            this.analysisMethod(model.analysisMethod);
            this.creatorAccountId(model.creatorAccountId);
            this.name(model.name);
            this.collaborationId(model.collaborationId);
            this.collaborationArn(model.collaborationArn);
            this.description(model.description);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.type(model.type);
            this.schemaStatusDetails(model.schemaStatusDetails);
        }

        public final List<Column.Builder> getColumns() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Column ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<Column.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Column.Builder> getPartitionKeys() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Column ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<Column.Builder> ... partitionKeys) {
            this.partitionKeys(Stream.of(partitionKeys).map(c -> (Column)((Column.Builder)Column.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (this.analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String ... analysisRuleTypes) {
            this.analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<AnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(AnalysisRuleType ... analysisRuleTypes) {
            this.analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return this.collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<SchemaStatusDetail.Builder> getSchemaStatusDetails() {
            List<SchemaStatusDetail.Builder> result = SchemaStatusDetailListCopier.copyToBuilder(this.schemaStatusDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaStatusDetails(Collection<SchemaStatusDetail.BuilderImpl> schemaStatusDetails) {
            this.schemaStatusDetails = SchemaStatusDetailListCopier.copyFromBuilder(schemaStatusDetails);
        }

        @Override
        public final Builder schemaStatusDetails(Collection<SchemaStatusDetail> schemaStatusDetails) {
            this.schemaStatusDetails = SchemaStatusDetailListCopier.copy(schemaStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaStatusDetails(SchemaStatusDetail ... schemaStatusDetails) {
            this.schemaStatusDetails(Arrays.asList(schemaStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaStatusDetails(Consumer<SchemaStatusDetail.Builder> ... schemaStatusDetails) {
            this.schemaStatusDetails(Stream.of(schemaStatusDetails).map(c -> (SchemaStatusDetail)((SchemaStatusDetail.Builder)SchemaStatusDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schema> {
        public Builder columns(Collection<Column> var1);

        public Builder columns(Column ... var1);

        public Builder columns(Consumer<Column.Builder> ... var1);

        public Builder partitionKeys(Collection<Column> var1);

        public Builder partitionKeys(Column ... var1);

        public Builder partitionKeys(Consumer<Column.Builder> ... var1);

        public Builder analysisRuleTypesWithStrings(Collection<String> var1);

        public Builder analysisRuleTypesWithStrings(String ... var1);

        public Builder analysisRuleTypes(Collection<AnalysisRuleType> var1);

        public Builder analysisRuleTypes(AnalysisRuleType ... var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);

        public Builder creatorAccountId(String var1);

        public Builder name(String var1);

        public Builder collaborationId(String var1);

        public Builder collaborationArn(String var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder type(String var1);

        public Builder type(SchemaType var1);

        public Builder schemaStatusDetails(Collection<SchemaStatusDetail> var1);

        public Builder schemaStatusDetails(SchemaStatusDetail ... var1);

        public Builder schemaStatusDetails(Consumer<SchemaStatusDetail.Builder> ... var1);
    }
}

