/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnalysisTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdateAnalysisTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(UpdateAnalysisTemplateRequest.getter(UpdateAnalysisTemplateRequest::membershipIdentifier)).setter(UpdateAnalysisTemplateRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> ANALYSIS_TEMPLATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisTemplateIdentifier").getter(UpdateAnalysisTemplateRequest.getter(UpdateAnalysisTemplateRequest::analysisTemplateIdentifier)).setter(UpdateAnalysisTemplateRequest.setter(Builder::analysisTemplateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisTemplateIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAnalysisTemplateRequest.getter(UpdateAnalysisTemplateRequest::description)).setter(UpdateAnalysisTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, ANALYSIS_TEMPLATE_IDENTIFIER_FIELD, DESCRIPTION_FIELD));
    private final String membershipIdentifier;
    private final String analysisTemplateIdentifier;
    private final String description;

    private UpdateAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.analysisTemplateIdentifier = builder.analysisTemplateIdentifier;
        this.description = builder.description;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String analysisTemplateIdentifier() {
        return this.analysisTemplateIdentifier;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalysisTemplateRequest)) {
            return false;
        }
        UpdateAnalysisTemplateRequest other = (UpdateAnalysisTemplateRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.analysisTemplateIdentifier(), other.analysisTemplateIdentifier()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnalysisTemplateRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("AnalysisTemplateIdentifier", (Object)this.analysisTemplateIdentifier()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "analysisTemplateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.analysisTemplateIdentifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((UpdateAnalysisTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String analysisTemplateIdentifier;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalysisTemplateRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.analysisTemplateIdentifier(model.analysisTemplateIdentifier);
            this.description(model.description);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getAnalysisTemplateIdentifier() {
            return this.analysisTemplateIdentifier;
        }

        public final void setAnalysisTemplateIdentifier(String analysisTemplateIdentifier) {
            this.analysisTemplateIdentifier = analysisTemplateIdentifier;
        }

        @Override
        public final Builder analysisTemplateIdentifier(String analysisTemplateIdentifier) {
            this.analysisTemplateIdentifier = analysisTemplateIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnalysisTemplateRequest build() {
            return new UpdateAnalysisTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnalysisTemplateRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder analysisTemplateIdentifier(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

