/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.QueryTablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisSchema> {
    private static final SdkField<List<String>> REFERENCED_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referencedTables").getter(AnalysisSchema.getter(AnalysisSchema::referencedTables)).setter(AnalysisSchema.setter(Builder::referencedTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referencedTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCED_TABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> referencedTables;

    private AnalysisSchema(BuilderImpl builder) {
        this.referencedTables = builder.referencedTables;
    }

    public final boolean hasReferencedTables() {
        return this.referencedTables != null && !(this.referencedTables instanceof SdkAutoConstructList);
    }

    public final List<String> referencedTables() {
        return this.referencedTables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferencedTables() ? this.referencedTables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSchema)) {
            return false;
        }
        AnalysisSchema other = (AnalysisSchema)obj;
        return this.hasReferencedTables() == other.hasReferencedTables() && Objects.equals(this.referencedTables(), other.referencedTables());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisSchema").add("ReferencedTables", this.hasReferencedTables() ? this.referencedTables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "referencedTables": {
                return Optional.ofNullable(clazz.cast(this.referencedTables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSchema, T> g) {
        return obj -> g.apply((AnalysisSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> referencedTables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSchema model) {
            this.referencedTables(model.referencedTables);
        }

        public final Collection<String> getReferencedTables() {
            if (this.referencedTables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referencedTables;
        }

        public final void setReferencedTables(Collection<String> referencedTables) {
            this.referencedTables = QueryTablesCopier.copy(referencedTables);
        }

        @Override
        public final Builder referencedTables(Collection<String> referencedTables) {
            this.referencedTables = QueryTablesCopier.copy(referencedTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedTables(String ... referencedTables) {
            this.referencedTables(Arrays.asList(referencedTables));
            return this;
        }

        public AnalysisSchema build() {
            return new AnalysisSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisSchema> {
        public Builder referencedTables(Collection<String> var1);

        public Builder referencedTables(String ... var1);
    }
}

