/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse;

public class ListConfiguredTableAssociationsPublisher
implements SdkPublisher<ListConfiguredTableAssociationsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListConfiguredTableAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredTableAssociationsPublisher(CleanRoomsAsyncClient client, ListConfiguredTableAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredTableAssociationsPublisher(CleanRoomsAsyncClient client, ListConfiguredTableAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredTableAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredTableAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredTableAssociationSummary> configuredTableAssociationSummaries() {
        Function<ListConfiguredTableAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredTableAssociationSummaries() != null) {
                return response.configuredTableAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredTableAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredTableAssociationsResponseFetcher
    implements AsyncPageFetcher<ListConfiguredTableAssociationsResponse> {
        private ListConfiguredTableAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredTableAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredTableAssociationsResponse> nextPage(ListConfiguredTableAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredTableAssociationsPublisher.this.client.listConfiguredTableAssociations(ListConfiguredTableAssociationsPublisher.this.firstRequest);
            }
            return ListConfiguredTableAssociationsPublisher.this.client.listConfiguredTableAssociations((ListConfiguredTableAssociationsRequest)((Object)ListConfiguredTableAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

