/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsResponse;

public class ListCollaborationPrivacyBudgetsIterable
implements SdkIterable<ListCollaborationPrivacyBudgetsResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationPrivacyBudgetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationPrivacyBudgetsIterable(CleanRoomsClient client, ListCollaborationPrivacyBudgetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationPrivacyBudgetsResponseFetcher();
    }

    public Iterator<ListCollaborationPrivacyBudgetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries() {
        Function<ListCollaborationPrivacyBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationPrivacyBudgetSummaries() != null) {
                return response.collaborationPrivacyBudgetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationPrivacyBudgetsResponseFetcher
    implements SyncPageFetcher<ListCollaborationPrivacyBudgetsResponse> {
        private ListCollaborationPrivacyBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationPrivacyBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationPrivacyBudgetsResponse nextPage(ListCollaborationPrivacyBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationPrivacyBudgetsIterable.this.client.listCollaborationPrivacyBudgets(ListCollaborationPrivacyBudgetsIterable.this.firstRequest);
            }
            return ListCollaborationPrivacyBudgetsIterable.this.client.listCollaborationPrivacyBudgets((ListCollaborationPrivacyBudgetsRequest)((Object)ListCollaborationPrivacyBudgetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

