/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary;

public class ListPrivacyBudgetTemplatesIterable
implements SdkIterable<ListPrivacyBudgetTemplatesResponse> {
    private final CleanRoomsClient client;
    private final ListPrivacyBudgetTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrivacyBudgetTemplatesIterable(CleanRoomsClient client, ListPrivacyBudgetTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrivacyBudgetTemplatesResponseFetcher();
    }

    public Iterator<ListPrivacyBudgetTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries() {
        Function<ListPrivacyBudgetTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.privacyBudgetTemplateSummaries() != null) {
                return response.privacyBudgetTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrivacyBudgetTemplatesResponseFetcher
    implements SyncPageFetcher<ListPrivacyBudgetTemplatesResponse> {
        private ListPrivacyBudgetTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivacyBudgetTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrivacyBudgetTemplatesResponse nextPage(ListPrivacyBudgetTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListPrivacyBudgetTemplatesIterable.this.client.listPrivacyBudgetTemplates(ListPrivacyBudgetTemplatesIterable.this.firstRequest);
            }
            return ListPrivacyBudgetTemplatesIterable.this.client.listPrivacyBudgetTemplates((ListPrivacyBudgetTemplatesRequest)((Object)ListPrivacyBudgetTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

