/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetsResponse;

public class ListCollaborationPrivacyBudgetsPublisher
implements SdkPublisher<ListCollaborationPrivacyBudgetsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationPrivacyBudgetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationPrivacyBudgetsPublisher(CleanRoomsAsyncClient client, ListCollaborationPrivacyBudgetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationPrivacyBudgetsPublisher(CleanRoomsAsyncClient client, ListCollaborationPrivacyBudgetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationPrivacyBudgetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationPrivacyBudgetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries() {
        Function<ListCollaborationPrivacyBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationPrivacyBudgetSummaries() != null) {
                return response.collaborationPrivacyBudgetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationPrivacyBudgetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationPrivacyBudgetsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationPrivacyBudgetsResponse> {
        private ListCollaborationPrivacyBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationPrivacyBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationPrivacyBudgetsResponse> nextPage(ListCollaborationPrivacyBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationPrivacyBudgetsPublisher.this.client.listCollaborationPrivacyBudgets(ListCollaborationPrivacyBudgetsPublisher.this.firstRequest);
            }
            return ListCollaborationPrivacyBudgetsPublisher.this.client.listCollaborationPrivacyBudgets((ListCollaborationPrivacyBudgetsRequest)((Object)ListCollaborationPrivacyBudgetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

