/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary;

public class ListProtectedQueriesPublisher
implements SdkPublisher<ListProtectedQueriesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListProtectedQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectedQueriesPublisher(CleanRoomsAsyncClient client, ListProtectedQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectedQueriesPublisher(CleanRoomsAsyncClient client, ListProtectedQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectedQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectedQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProtectedQuerySummary> protectedQueries() {
        Function<ListProtectedQueriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.protectedQueries() != null) {
                return response.protectedQueries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProtectedQueriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProtectedQueriesResponseFetcher
    implements AsyncPageFetcher<ListProtectedQueriesResponse> {
        private ListProtectedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectedQueriesResponse> nextPage(ListProtectedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedQueriesPublisher.this.client.listProtectedQueries(ListProtectedQueriesPublisher.this.firstRequest);
            }
            return ListProtectedQueriesPublisher.this.client.listProtectedQueries((ListProtectedQueriesRequest)((Object)ListProtectedQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

