/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.SchemaSummary;
import software.amazon.awssdk.services.cleanrooms.model.SchemaSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemasResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListSchemasResponse> {
    private static final SdkField<List<SchemaSummary>> SCHEMA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemaSummaries").getter(ListSchemasResponse.getter(ListSchemasResponse::schemaSummaries)).setter(ListSchemasResponse.setter(Builder::schemaSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSchemasResponse.getter(ListSchemasResponse::nextToken)).setter(ListSchemasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SchemaSummary> schemaSummaries;
    private final String nextToken;

    private ListSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.schemaSummaries = builder.schemaSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSchemaSummaries() {
        return this.schemaSummaries != null && !(this.schemaSummaries instanceof SdkAutoConstructList);
    }

    public final List<SchemaSummary> schemaSummaries() {
        return this.schemaSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaSummaries() ? this.schemaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResponse)) {
            return false;
        }
        ListSchemasResponse other = (ListSchemasResponse)((Object)obj);
        return this.hasSchemaSummaries() == other.hasSchemaSummaries() && Objects.equals(this.schemaSummaries(), other.schemaSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchemasResponse").add("SchemaSummaries", this.hasSchemaSummaries() ? this.schemaSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaSummaries": {
                return Optional.ofNullable(clazz.cast(this.schemaSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasResponse, T> g) {
        return obj -> g.apply((ListSchemasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<SchemaSummary> schemaSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasResponse model) {
            super(model);
            this.schemaSummaries(model.schemaSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SchemaSummary.Builder> getSchemaSummaries() {
            List<SchemaSummary.Builder> result = SchemaSummaryListCopier.copyToBuilder(this.schemaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaSummaries(Collection<SchemaSummary.BuilderImpl> schemaSummaries) {
            this.schemaSummaries = SchemaSummaryListCopier.copyFromBuilder(schemaSummaries);
        }

        @Override
        public final Builder schemaSummaries(Collection<SchemaSummary> schemaSummaries) {
            this.schemaSummaries = SchemaSummaryListCopier.copy(schemaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaSummaries(SchemaSummary ... schemaSummaries) {
            this.schemaSummaries(Arrays.asList(schemaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaSummaries(Consumer<SchemaSummary.Builder> ... schemaSummaries) {
            this.schemaSummaries(Stream.of(schemaSummaries).map(c -> (SchemaSummary)((SchemaSummary.Builder)SchemaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchemasResponse build() {
            return new ListSchemasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemasResponse> {
        public Builder schemaSummaries(Collection<SchemaSummary> var1);

        public Builder schemaSummaries(SchemaSummary ... var1);

        public Builder schemaSummaries(Consumer<SchemaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

