/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AggregateColumnColumnNamesListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AggregateFunctionName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateColumn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateColumn> {
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnNames").getter(AggregateColumn.getter(AggregateColumn::columnNames)).setter(AggregateColumn.setter(Builder::columnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(AggregateColumn.getter(AggregateColumn::functionAsString)).setter(AggregateColumn.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAMES_FIELD, FUNCTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> columnNames;
    private final String function;

    private AggregateColumn(BuilderImpl builder) {
        this.columnNames = builder.columnNames;
        this.function = builder.function;
    }

    public final boolean hasColumnNames() {
        return this.columnNames != null && !(this.columnNames instanceof SdkAutoConstructList);
    }

    public final List<String> columnNames() {
        return this.columnNames;
    }

    public final AggregateFunctionName function() {
        return AggregateFunctionName.fromValue(this.function);
    }

    public final String functionAsString() {
        return this.function;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNames() ? this.columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.functionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateColumn)) {
            return false;
        }
        AggregateColumn other = (AggregateColumn)obj;
        return this.hasColumnNames() == other.hasColumnNames() && Objects.equals(this.columnNames(), other.columnNames()) && Objects.equals(this.functionAsString(), other.functionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateColumn").add("ColumnNames", this.hasColumnNames() ? this.columnNames() : null).add("Function", (Object)this.functionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNames()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.functionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateColumn, T> g) {
        return obj -> g.apply((AggregateColumn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();
        private String function;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateColumn model) {
            this.columnNames(model.columnNames);
            this.function(model.function);
        }

        public final Collection<String> getColumnNames() {
            if (this.columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = AggregateColumnColumnNamesListCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = AggregateColumnColumnNamesListCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(AggregateFunctionName function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        public AggregateColumn build() {
            return new AggregateColumn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateColumn> {
        public Builder columnNames(Collection<String> var1);

        public Builder columnNames(String ... var1);

        public Builder function(String var1);

        public Builder function(AggregateFunctionName var1);
    }
}

