/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationQueryLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.DataEncryptionMetadata;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbilitiesCopier;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbility;
import software.amazon.awssdk.services.cleanrooms.model.MemberListCopier;
import software.amazon.awssdk.services.cleanrooms.model.MemberSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCollaborationRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateCollaborationRequest> {
    private static final SdkField<List<MemberSpecification>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("members").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::members)).setter(CreateCollaborationRequest.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::name)).setter(CreateCollaborationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::description)).setter(CreateCollaborationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> CREATOR_MEMBER_ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("creatorMemberAbilities").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::creatorMemberAbilitiesAsStrings)).setter(CreateCollaborationRequest.setter(Builder::creatorMemberAbilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorMemberAbilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorDisplayName").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::creatorDisplayName)).setter(CreateCollaborationRequest.setter(Builder::creatorDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorDisplayName").build()}).build();
    private static final SdkField<DataEncryptionMetadata> DATA_ENCRYPTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataEncryptionMetadata").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::dataEncryptionMetadata)).setter(CreateCollaborationRequest.setter(Builder::dataEncryptionMetadata)).constructor(DataEncryptionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataEncryptionMetadata").build()}).build();
    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLogStatus").getter(CreateCollaborationRequest.getter(CreateCollaborationRequest::queryLogStatusAsString)).setter(CreateCollaborationRequest.setter(Builder::queryLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATOR_MEMBER_ABILITIES_FIELD, CREATOR_DISPLAY_NAME_FIELD, DATA_ENCRYPTION_METADATA_FIELD, QUERY_LOG_STATUS_FIELD));
    private final List<MemberSpecification> members;
    private final String name;
    private final String description;
    private final List<String> creatorMemberAbilities;
    private final String creatorDisplayName;
    private final DataEncryptionMetadata dataEncryptionMetadata;
    private final String queryLogStatus;

    private CreateCollaborationRequest(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.name = builder.name;
        this.description = builder.description;
        this.creatorMemberAbilities = builder.creatorMemberAbilities;
        this.creatorDisplayName = builder.creatorDisplayName;
        this.dataEncryptionMetadata = builder.dataEncryptionMetadata;
        this.queryLogStatus = builder.queryLogStatus;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<MemberSpecification> members() {
        return this.members;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<MemberAbility> creatorMemberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(this.creatorMemberAbilities);
    }

    public final boolean hasCreatorMemberAbilities() {
        return this.creatorMemberAbilities != null && !(this.creatorMemberAbilities instanceof SdkAutoConstructList);
    }

    public final List<String> creatorMemberAbilitiesAsStrings() {
        return this.creatorMemberAbilities;
    }

    public final String creatorDisplayName() {
        return this.creatorDisplayName;
    }

    public final DataEncryptionMetadata dataEncryptionMetadata() {
        return this.dataEncryptionMetadata;
    }

    public final CollaborationQueryLogStatus queryLogStatus() {
        return CollaborationQueryLogStatus.fromValue(this.queryLogStatus);
    }

    public final String queryLogStatusAsString() {
        return this.queryLogStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatorMemberAbilities() ? this.creatorMemberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncryptionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollaborationRequest)) {
            return false;
        }
        CreateCollaborationRequest other = (CreateCollaborationRequest)((Object)obj);
        return this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasCreatorMemberAbilities() == other.hasCreatorMemberAbilities() && Objects.equals(this.creatorMemberAbilitiesAsStrings(), other.creatorMemberAbilitiesAsStrings()) && Objects.equals(this.creatorDisplayName(), other.creatorDisplayName()) && Objects.equals(this.dataEncryptionMetadata(), other.dataEncryptionMetadata()) && Objects.equals(this.queryLogStatusAsString(), other.queryLogStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCollaborationRequest").add("Members", this.hasMembers() ? this.members() : null).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatorMemberAbilities", this.hasCreatorMemberAbilities() ? this.creatorMemberAbilitiesAsStrings() : null).add("CreatorDisplayName", (Object)this.creatorDisplayName()).add("DataEncryptionMetadata", (Object)this.dataEncryptionMetadata()).add("QueryLogStatus", (Object)this.queryLogStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creatorMemberAbilities": {
                return Optional.ofNullable(clazz.cast(this.creatorMemberAbilitiesAsStrings()));
            }
            case "creatorDisplayName": {
                return Optional.ofNullable(clazz.cast(this.creatorDisplayName()));
            }
            case "dataEncryptionMetadata": {
                return Optional.ofNullable(clazz.cast(this.dataEncryptionMetadata()));
            }
            case "queryLogStatus": {
                return Optional.ofNullable(clazz.cast(this.queryLogStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCollaborationRequest, T> g) {
        return obj -> g.apply((CreateCollaborationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private List<MemberSpecification> members = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String description;
        private List<String> creatorMemberAbilities = DefaultSdkAutoConstructList.getInstance();
        private String creatorDisplayName;
        private DataEncryptionMetadata dataEncryptionMetadata;
        private String queryLogStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollaborationRequest model) {
            super(model);
            this.members(model.members);
            this.name(model.name);
            this.description(model.description);
            this.creatorMemberAbilitiesWithStrings(model.creatorMemberAbilities);
            this.creatorDisplayName(model.creatorDisplayName);
            this.dataEncryptionMetadata(model.dataEncryptionMetadata);
            this.queryLogStatus(model.queryLogStatus);
        }

        public final List<MemberSpecification.Builder> getMembers() {
            List<MemberSpecification.Builder> result = MemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<MemberSpecification.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<MemberSpecification> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(MemberSpecification ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<MemberSpecification.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (MemberSpecification)((MemberSpecification.Builder)MemberSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCreatorMemberAbilities() {
            if (this.creatorMemberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.creatorMemberAbilities;
        }

        public final void setCreatorMemberAbilities(Collection<String> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copy(creatorMemberAbilities);
        }

        @Override
        public final Builder creatorMemberAbilitiesWithStrings(Collection<String> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copy(creatorMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creatorMemberAbilitiesWithStrings(String ... creatorMemberAbilities) {
            this.creatorMemberAbilitiesWithStrings(Arrays.asList(creatorMemberAbilities));
            return this;
        }

        @Override
        public final Builder creatorMemberAbilities(Collection<MemberAbility> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copyEnumToString(creatorMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creatorMemberAbilities(MemberAbility ... creatorMemberAbilities) {
            this.creatorMemberAbilities(Arrays.asList(creatorMemberAbilities));
            return this;
        }

        public final String getCreatorDisplayName() {
            return this.creatorDisplayName;
        }

        public final void setCreatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
        }

        @Override
        public final Builder creatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        public final DataEncryptionMetadata.Builder getDataEncryptionMetadata() {
            return this.dataEncryptionMetadata != null ? this.dataEncryptionMetadata.toBuilder() : null;
        }

        public final void setDataEncryptionMetadata(DataEncryptionMetadata.BuilderImpl dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata != null ? dataEncryptionMetadata.build() : null;
        }

        @Override
        public final Builder dataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        public final String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(CollaborationQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCollaborationRequest build() {
            return new CreateCollaborationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCollaborationRequest> {
        public Builder members(Collection<MemberSpecification> var1);

        public Builder members(MemberSpecification ... var1);

        public Builder members(Consumer<MemberSpecification.Builder> ... var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder creatorMemberAbilitiesWithStrings(Collection<String> var1);

        public Builder creatorMemberAbilitiesWithStrings(String ... var1);

        public Builder creatorMemberAbilities(Collection<MemberAbility> var1);

        public Builder creatorMemberAbilities(MemberAbility ... var1);

        public Builder creatorDisplayName(String var1);

        public Builder dataEncryptionMetadata(DataEncryptionMetadata var1);

        default public Builder dataEncryptionMetadata(Consumer<DataEncryptionMetadata.Builder> dataEncryptionMetadata) {
            return this.dataEncryptionMetadata((DataEncryptionMetadata)((DataEncryptionMetadata.Builder)DataEncryptionMetadata.builder().applyMutation(dataEncryptionMetadata)).build());
        }

        public Builder queryLogStatus(String var1);

        public Builder queryLogStatus(CollaborationQueryLogStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

