/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.E164PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociatePhoneNumbersFromVoiceConnectorRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, DisassociatePhoneNumbersFromVoiceConnectorRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(DisassociatePhoneNumbersFromVoiceConnectorRequest.getter(DisassociatePhoneNumbersFromVoiceConnectorRequest::voiceConnectorId)).setter(DisassociatePhoneNumbersFromVoiceConnectorRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("E164PhoneNumbers").getter(DisassociatePhoneNumbersFromVoiceConnectorRequest.getter(DisassociatePhoneNumbersFromVoiceConnectorRequest::e164PhoneNumbers)).setter(DisassociatePhoneNumbersFromVoiceConnectorRequest.setter(Builder::e164PhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, E164_PHONE_NUMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociatePhoneNumbersFromVoiceConnectorRequest.memberNameToFieldInitializer();
    private final String voiceConnectorId;
    private final List<String> e164PhoneNumbers;

    private DisassociatePhoneNumbersFromVoiceConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final boolean hasE164PhoneNumbers() {
        return this.e164PhoneNumbers != null && !(this.e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> e164PhoneNumbers() {
        return this.e164PhoneNumbers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasE164PhoneNumbers() ? this.e164PhoneNumbers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePhoneNumbersFromVoiceConnectorRequest)) {
            return false;
        }
        DisassociatePhoneNumbersFromVoiceConnectorRequest other = (DisassociatePhoneNumbersFromVoiceConnectorRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && this.hasE164PhoneNumbers() == other.hasE164PhoneNumbers() && Objects.equals(this.e164PhoneNumbers(), other.e164PhoneNumbers());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociatePhoneNumbersFromVoiceConnectorRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("E164PhoneNumbers", (Object)(this.e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "E164PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumbers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
        map.put("E164PhoneNumbers", E164_PHONE_NUMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociatePhoneNumbersFromVoiceConnectorRequest, T> g) {
        return obj -> g.apply((DisassociatePhoneNumbersFromVoiceConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePhoneNumbersFromVoiceConnectorRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.e164PhoneNumbers(model.e164PhoneNumbers);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (this.e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.e164PhoneNumbers;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String ... e164PhoneNumbers) {
            this.e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociatePhoneNumbersFromVoiceConnectorRequest build() {
            return new DisassociatePhoneNumbersFromVoiceConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociatePhoneNumbersFromVoiceConnectorRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder e164PhoneNumbers(Collection<String> var1);

        public Builder e164PhoneNumbers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

